/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.properties.type.BooleanProperty;
import org.geysermc.geyser.entity.properties.type.EnumProperty;
import org.geysermc.geyser.entity.type.living.GolemEntity;
import org.geysermc.geyser.impl.IdentifierImpl;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.CopperGolemState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.MetadataType;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.WeatheringCopperState;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class CopperGolemEntity
extends GolemEntity {
    public static final BooleanProperty HAS_FLOWER_PROPERTY = new BooleanProperty(IdentifierImpl.of("has_flower"), false);
    public static final EnumProperty<ChestInteractionState> CHEST_INTERACTION_PROPERTY = new EnumProperty<ChestInteractionState>(IdentifierImpl.of("chest_interaction"), ChestInteractionState.class, ChestInteractionState.NONE);
    public static final EnumProperty<OxidationLevelState> OXIDATION_LEVEL_STATE_ENUM_PROPERTY = new EnumProperty<OxidationLevelState>(IdentifierImpl.of("oxidation_level"), OxidationLevelState.class, OxidationLevelState.UNOXIDIZED);

    public CopperGolemEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.isEmpty() && !this.getMainHandItem().isEmpty()) {
            return InteractiveTag.DROP_ITEM;
        }
        if (itemInHand.is(Items.SHEARS) && this.canBeSheared()) {
            return InteractiveTag.SHEAR;
        }
        if (itemInHand.is(Items.HONEYCOMB)) {
            return InteractiveTag.WAX_ON;
        }
        if (itemInHand.is(this.session, ItemTag.AXES)) {
            return InteractiveTag.SCRAPE;
        }
        return super.testMobInteraction(hand, itemInHand);
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand usedHand, @NonNull GeyserItemStack itemInHand) {
        if (itemInHand.isEmpty() && !this.getMainHandItem().isEmpty() || itemInHand.is(Items.SHEARS) && this.canBeSheared()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean canBeSheared() {
        return this.isAlive() && this.getItemInSlot(EquipmentSlot.HELMET).is(this.session, ItemTag.SHEARABLE_FROM_COPPER_GOLEM);
    }

    @Override
    public void setSaddle(GeyserItemStack stack) {
        super.setSaddle(stack);
        HAS_FLOWER_PROPERTY.apply(this.propertyManager, stack.is(Items.POPPY));
        this.updateBedrockEntityProperties();
    }

    public void setWeatheringState(EntityMetadata<WeatheringCopperState, ? extends MetadataType<WeatheringCopperState>> metadata) {
        WeatheringCopperState state = (WeatheringCopperState)metadata.getValue();
        OXIDATION_LEVEL_STATE_ENUM_PROPERTY.apply(this.propertyManager, switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case WeatheringCopperState.UNAFFECTED -> OxidationLevelState.UNOXIDIZED;
            case WeatheringCopperState.EXPOSED -> OxidationLevelState.EXPOSED;
            case WeatheringCopperState.WEATHERED -> OxidationLevelState.WEATHERED;
            case WeatheringCopperState.OXIDIZED -> OxidationLevelState.OXIDIZED;
        });
        this.updateBedrockEntityProperties();
    }

    public void setGolemState(EntityMetadata<CopperGolemState, ? extends MetadataType<CopperGolemState>> metadata) {
        CopperGolemState state = (CopperGolemState)metadata.getValue();
        CHEST_INTERACTION_PROPERTY.apply(this.propertyManager, switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case CopperGolemState.IDLE -> ChestInteractionState.NONE;
            case CopperGolemState.GETTING_ITEM -> ChestInteractionState.TAKE;
            case CopperGolemState.GETTING_NO_ITEM -> ChestInteractionState.TAKE_FAIL;
            case CopperGolemState.DROPPING_ITEM -> ChestInteractionState.PUT;
            case CopperGolemState.DROPPING_NO_ITEM -> ChestInteractionState.PUT_FAIL;
        });
        this.updateBedrockEntityProperties();
    }

    public static enum OxidationLevelState {
        UNOXIDIZED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }

    public static enum ChestInteractionState {
        NONE,
        TAKE,
        TAKE_FAIL,
        PUT,
        PUT_FAIL;

    }
}

