/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.monster.raid;

import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.monster.raid.AbstractIllagerEntity;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.BooleanEntityMetadata;

public class PillagerEntity
extends AbstractIllagerEntity {
    public PillagerEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setChargingCrossbow(BooleanEntityMetadata entityMetadata) {
        boolean charging = entityMetadata.getPrimitiveValue();
        this.setFlag(EntityFlag.CHARGING, charging);
        this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, charging ? (byte)64 : 0);
    }

    @Override
    public void updateMainHand(GeyserSession session) {
        this.updateCrossbow();
        super.updateMainHand(session);
    }

    @Override
    public void updateOffHand(GeyserSession session) {
        this.updateCrossbow();
        super.updateOffHand(session);
    }

    protected void updateCrossbow() {
        ItemMapping crossbow = this.session.getItemMappings().getStoredItems().crossbow();
        ItemData activeCrossbow = null;
        if (this.hand.getDefinition() == crossbow.getBedrockDefinition()) {
            activeCrossbow = this.hand;
        } else if (this.offhand.getDefinition() == crossbow.getBedrockDefinition()) {
            activeCrossbow = this.offhand;
        }
        if (activeCrossbow != null) {
            if (activeCrossbow.getTag() != null && activeCrossbow.getTag().containsKey((Object)"chargedItem")) {
                this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, (byte)127);
                this.setFlag(EntityFlag.CHARGING, false);
                this.setFlag(EntityFlag.CHARGED, true);
                this.setFlag(EntityFlag.USING_ITEM, true);
            } else if (this.getFlag(EntityFlag.CHARGED)) {
                this.dirtyMetadata.put(EntityDataTypes.CHARGE_AMOUNT, (byte)0);
                this.setFlag(EntityFlag.CHARGED, false);
                this.setFlag(EntityFlag.USING_ITEM, false);
            }
        }
        this.updateBedrockMetadata();
    }
}

