/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.type;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.registry.type.ItemMapping;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.item.BedrockItemBuilder;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;

public class EnchantedBookItem
extends Item {
    public EnchantedBookItem(String javaIdentifier, Item.Builder builder) {
        super(javaIdentifier, builder);
    }

    @Override
    public void translateComponentsToBedrock(@NonNull GeyserSession session, @NonNull DataComponents components, @NonNull BedrockItemBuilder builder) {
        super.translateComponentsToBedrock(session, components, builder);
        ArrayList<NbtMap> bedrockEnchants = new ArrayList<NbtMap>();
        ItemEnchantments enchantments = components.get(DataComponentTypes.STORED_ENCHANTMENTS);
        if (enchantments != null) {
            for (Map.Entry<Integer, Integer> enchantment : enchantments.getEnchantments().entrySet()) {
                NbtMap bedrockTag = this.remapEnchantment(session, enchantment.getKey(), enchantment.getValue(), builder);
                if (bedrockTag == null) continue;
                bedrockEnchants.add(bedrockTag);
            }
        }
        if (!bedrockEnchants.isEmpty()) {
            builder.putList("ench", NbtType.COMPOUND, bedrockEnchants);
        }
    }

    @Override
    public void translateNbtToJava(@NonNull GeyserSession session, @NonNull NbtMap bedrockTag, @NonNull DataComponents components, @NonNull ItemMapping mapping) {
        super.translateNbtToJava(session, bedrockTag, components, mapping);
        List enchantmentTag = bedrockTag.getList("ench", NbtType.COMPOUND);
        if (enchantmentTag != null) {
            Int2IntOpenHashMap javaEnchantments = new Int2IntOpenHashMap(enchantmentTag.size());
            block0: for (NbtMap bedrockEnchantment : enchantmentTag) {
                short bedrockId = bedrockEnchantment.getShort("id");
                BedrockEnchantment enchantment = BedrockEnchantment.getByBedrockId(bedrockId);
                if (enchantment != null) {
                    List<Enchantment> enchantments = session.getRegistryCache().enchantments().values();
                    for (int i = 0; i < enchantments.size(); ++i) {
                        if (enchantments.get(i).bedrockEnchantment() != enchantment) continue;
                        short level = bedrockEnchantment.getShort("lvl", (short)1);
                        javaEnchantments.put(i, (int)level);
                        continue block0;
                    }
                    continue;
                }
                GeyserImpl.getInstance().getLogger().debug("Unknown bedrock enchantment: " + bedrockId);
            }
            if (!javaEnchantments.isEmpty()) {
                components.put(DataComponentTypes.STORED_ENCHANTMENTS, new ItemEnchantments((Map<Integer, Integer>)javaEnchantments, true));
            }
        }
    }
}

