/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.SlotType;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.item.type.BannerItem;
import org.geysermc.geyser.item.type.DyeItem;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftLoomAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.CraftResultsDeprecatedAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestActionType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.BannerPatternLayer;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundContainerButtonClickPacket;

public class LoomInventoryTranslator
extends AbstractBlockInventoryTranslator {
    private static final Object2IntMap<String> PATTERN_TO_INDEX = new Object2IntOpenHashMap();

    public LoomInventoryTranslator() {
        super(4, Blocks.LOOM, ContainerType.LOOM, (InventoryUpdater)UIInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    protected boolean shouldRejectItemPlace(GeyserSession session, Inventory inventory, ContainerSlotType bedrockSourceContainer, int javaSourceSlot, ContainerSlotType bedrockDestinationContainer, int javaDestinationSlot) {
        GeyserItemStack itemStack;
        if (javaDestinationSlot != 1) {
            return false;
        }
        GeyserItemStack geyserItemStack = itemStack = javaSourceSlot == -1 ? session.getPlayerInventory().getCursor() : inventory.getItem(javaSourceSlot);
        if (itemStack.isEmpty()) {
            return false;
        }
        return !(itemStack.asItem() instanceof DyeItem);
    }

    @Override
    protected boolean shouldHandleRequestFirst(ItemStackRequestAction action, Inventory inventory) {
        return action.getType() == ItemStackRequestActionType.CRAFT_LOOM && inventory.getItem(2).isEmpty();
    }

    @Override
    public ItemStackResponse translateSpecialRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        ItemStackRequestAction headerData = request.getActions()[0];
        ItemStackRequestAction data = request.getActions()[1];
        if (!(headerData instanceof CraftLoomAction)) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        if (!(data instanceof CraftResultsDeprecatedAction)) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        CraftResultsDeprecatedAction craftData = (CraftResultsDeprecatedAction)data;
        String bedrockPattern = ((CraftLoomAction)headerData).getPatternId();
        int index = PATTERN_TO_INDEX.getOrDefault((Object)bedrockPattern, -1);
        if (index == -1) {
            return LoomInventoryTranslator.rejectRequest(request);
        }
        List newBlockEntityTag = craftData.getResultItems()[0].getTag().getList("Patterns", NbtType.COMPOUND);
        NbtMap pattern = (NbtMap)newBlockEntityTag.get(newBlockEntityTag.size() - 1);
        ServerboundContainerButtonClickPacket packet = new ServerboundContainerButtonClickPacket(inventory.getJavaId(), index);
        session.sendDownstreamGamePacket(packet);
        GeyserItemStack inputCopy = inventory.getItem(0).copy(1);
        inputCopy.setNetId(session.getNextItemNetId());
        BannerPatternLayer bannerPatternLayer = BannerItem.getJavaBannerPattern(session, pattern);
        if (bannerPatternLayer != null) {
            ArrayList<BannerPatternLayer> patternsList = new ArrayList<BannerPatternLayer>(inputCopy.getComponentElseGet(DataComponentTypes.BANNER_PATTERNS, ArrayList::new));
            patternsList.add(bannerPatternLayer);
            inputCopy.getOrCreateComponents().put(DataComponentTypes.BANNER_PATTERNS, patternsList);
        }
        inventory.setItem(3, inputCopy, session);
        return this.translateRequest(session, inventory, request);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainerName().getContainer()) {
            case ContainerSlotType.LOOM_INPUT -> 0;
            case ContainerSlotType.LOOM_DYE -> 1;
            case ContainerSlotType.LOOM_MATERIAL -> 2;
            case ContainerSlotType.LOOM_RESULT, ContainerSlotType.CREATED_OUTPUT -> 3;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.LOOM_INPUT, 9);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.LOOM_DYE, 10);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.LOOM_MATERIAL, 11);
            case 3 -> new BedrockContainerSlot(ContainerSlotType.LOOM_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot);
        };
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 9;
            case 1 -> 10;
            case 2 -> 11;
            case 3 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public SlotType getSlotType(int javaSlot) {
        if (javaSlot == 3) {
            return SlotType.OUTPUT;
        }
        return super.getSlotType(javaSlot);
    }

    @Override
    public @Nullable ContainerType closeContainerType(Inventory inventory) {
        return null;
    }

    static {
        int index = 0;
        PATTERN_TO_INDEX.put((Object)"bl", index++);
        PATTERN_TO_INDEX.put((Object)"br", index++);
        PATTERN_TO_INDEX.put((Object)"tl", index++);
        PATTERN_TO_INDEX.put((Object)"tr", index++);
        PATTERN_TO_INDEX.put((Object)"bs", index++);
        PATTERN_TO_INDEX.put((Object)"ts", index++);
        PATTERN_TO_INDEX.put((Object)"ls", index++);
        PATTERN_TO_INDEX.put((Object)"rs", index++);
        PATTERN_TO_INDEX.put((Object)"cs", index++);
        PATTERN_TO_INDEX.put((Object)"ms", index++);
        PATTERN_TO_INDEX.put((Object)"drs", index++);
        PATTERN_TO_INDEX.put((Object)"dls", index++);
        PATTERN_TO_INDEX.put((Object)"ss", index++);
        PATTERN_TO_INDEX.put((Object)"cr", index++);
        PATTERN_TO_INDEX.put((Object)"sc", index++);
        PATTERN_TO_INDEX.put((Object)"bt", index++);
        PATTERN_TO_INDEX.put((Object)"tt", index++);
        PATTERN_TO_INDEX.put((Object)"bts", index++);
        PATTERN_TO_INDEX.put((Object)"tts", index++);
        PATTERN_TO_INDEX.put((Object)"ld", index++);
        PATTERN_TO_INDEX.put((Object)"rd", index++);
        PATTERN_TO_INDEX.put((Object)"lud", index++);
        PATTERN_TO_INDEX.put((Object)"rud", index++);
        PATTERN_TO_INDEX.put((Object)"mc", index++);
        PATTERN_TO_INDEX.put((Object)"mr", index++);
        PATTERN_TO_INDEX.put((Object)"vh", index++);
        PATTERN_TO_INDEX.put((Object)"hh", index++);
        PATTERN_TO_INDEX.put((Object)"vhr", index++);
        PATTERN_TO_INDEX.put((Object)"hhb", index++);
        PATTERN_TO_INDEX.put((Object)"bo", index++);
        PATTERN_TO_INDEX.put((Object)"gra", index++);
        PATTERN_TO_INDEX.put((Object)"gru", index);
    }
}

