/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.inventory;

import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.inventory.BedrockContainerSlot;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.inventory.updater.UIInventoryUpdater;
import org.geysermc.geyser.level.block.Blocks;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerSlotType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequest;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.ItemStackRequestSlotData;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.DropAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.ItemStackRequestAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.PlaceAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.SwapAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.request.action.TakeAction;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.inventory.itemstack.response.ItemStackResponse;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.translator.inventory.AbstractBlockInventoryTranslator;
import org.geysermc.geyser.util.InventoryUtils;

public class OldSmithingTableTranslator
extends AbstractBlockInventoryTranslator {
    public static final OldSmithingTableTranslator INSTANCE = new OldSmithingTableTranslator();
    private static final IntFunction<ItemData> UPGRADE_TEMPLATE = InventoryUtils.getUpgradeTemplate();

    private OldSmithingTableTranslator() {
        super(3, Blocks.SMITHING_TABLE, ContainerType.SMITHING_TABLE, (InventoryUpdater)UIInventoryUpdater.INSTANCE, new Block[0]);
    }

    @Override
    public int bedrockSlotToJava(ItemStackRequestSlotData slotInfoData) {
        return switch (slotInfoData.getContainerName().getContainer()) {
            case ContainerSlotType.SMITHING_TABLE_INPUT -> 0;
            case ContainerSlotType.SMITHING_TABLE_MATERIAL -> 1;
            case ContainerSlotType.SMITHING_TABLE_RESULT, ContainerSlotType.CREATED_OUTPUT -> 2;
            default -> super.bedrockSlotToJava(slotInfoData);
        };
    }

    @Override
    public BedrockContainerSlot javaSlotToBedrockContainer(int slot) {
        return switch (slot) {
            case 0 -> new BedrockContainerSlot(ContainerSlotType.SMITHING_TABLE_INPUT, 51);
            case 1 -> new BedrockContainerSlot(ContainerSlotType.SMITHING_TABLE_MATERIAL, 52);
            case 2 -> new BedrockContainerSlot(ContainerSlotType.SMITHING_TABLE_RESULT, 50);
            default -> super.javaSlotToBedrockContainer(slot);
        };
    }

    @Override
    public int javaSlotToBedrock(int slot) {
        return switch (slot) {
            case 0 -> 51;
            case 1 -> 52;
            case 2 -> 50;
            default -> super.javaSlotToBedrock(slot);
        };
    }

    @Override
    public boolean shouldHandleRequestFirst(ItemStackRequestAction action, Inventory inventory) {
        return true;
    }

    @Override
    protected ItemStackResponse translateSpecialRequest(GeyserSession session, Inventory inventory, ItemStackRequest request) {
        block6: for (ItemStackRequestAction action : request.getActions()) {
            switch (action.getType()) {
                case DROP: {
                    if (!this.isInvalidAction(((DropAction)action).getSource())) continue block6;
                    return OldSmithingTableTranslator.rejectRequest(request, false);
                }
                case TAKE: {
                    if (!this.isInvalidAction(((TakeAction)action).getSource()) && !this.isInvalidAction(((TakeAction)action).getDestination())) continue block6;
                    return OldSmithingTableTranslator.rejectRequest(request, false);
                }
                case SWAP: {
                    if (!this.isInvalidAction(((SwapAction)action).getSource()) && !this.isInvalidAction(((SwapAction)action).getDestination())) continue block6;
                    return OldSmithingTableTranslator.rejectRequest(request, false);
                }
                case PLACE: {
                    if (!this.isInvalidAction(((PlaceAction)action).getSource()) && !this.isInvalidAction(((PlaceAction)action).getDestination())) continue block6;
                    return OldSmithingTableTranslator.rejectRequest(request, false);
                }
            }
        }
        return super.translateRequest(session, inventory, request);
    }

    private boolean isInvalidAction(ItemStackRequestSlotData slotData) {
        return slotData.getContainerName().getContainer().equals((Object)ContainerSlotType.SMITHING_TABLE_TEMPLATE);
    }

    @Override
    public void openInventory(GeyserSession session, Inventory inventory) {
        super.openInventory(session, inventory);
        InventorySlotPacket slotPacket = new InventorySlotPacket();
        slotPacket.setContainerId(124);
        slotPacket.setSlot(53);
        slotPacket.setItem(UPGRADE_TEMPLATE.apply(session.getUpstream().getProtocolVersion()));
        session.sendUpstreamPacket(slotPacket);
    }

    @Override
    public @Nullable ContainerType closeContainerType(Inventory inventory) {
        return null;
    }
}

