/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.item.component;

import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Fireworks {
    private final int flightDuration;
    private final List<FireworkExplosion> explosions;

    public Fireworks(int flightDuration, List<FireworkExplosion> explosions) {
        this.flightDuration = flightDuration;
        this.explosions = List.copyOf(explosions);
    }

    public int getFlightDuration() {
        return this.flightDuration;
    }

    public List<FireworkExplosion> getExplosions() {
        return this.explosions;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Fireworks)) {
            return false;
        }
        Fireworks other = (Fireworks)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFlightDuration() != other.getFlightDuration()) {
            return false;
        }
        List<FireworkExplosion> this$explosions = this.getExplosions();
        List<FireworkExplosion> other$explosions = other.getExplosions();
        return !(this$explosions == null ? other$explosions != null : !((Object)this$explosions).equals(other$explosions));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof Fireworks;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFlightDuration();
        List<FireworkExplosion> $explosions = this.getExplosions();
        result = result * 59 + ($explosions == null ? 43 : ((Object)$explosions).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "Fireworks(flightDuration=" + this.getFlightDuration() + ", explosions=" + String.valueOf(this.getExplosions()) + ")";
    }

    public @NonNull Fireworks withFlightDuration(int flightDuration) {
        return this.flightDuration == flightDuration ? this : new Fireworks(flightDuration, this.explosions);
    }

    public @NonNull Fireworks withExplosions(List<FireworkExplosion> explosions) {
        return this.explosions == explosions ? this : new Fireworks(this.flightDuration, explosions);
    }

    public static class FireworkExplosion {
        private final int shapeId;
        private final int[] colors;
        private final int[] fadeColors;
        private final boolean hasTrail;
        private final boolean hasTwinkle;

        public static @NonNull FireworkExplosionBuilder builder() {
            return new FireworkExplosionBuilder();
        }

        public @NonNull FireworkExplosionBuilder toBuilder() {
            return new FireworkExplosionBuilder().shapeId(this.shapeId).colors(this.colors).fadeColors(this.fadeColors).hasTrail(this.hasTrail).hasTwinkle(this.hasTwinkle);
        }

        public int getShapeId() {
            return this.shapeId;
        }

        public int[] getColors() {
            return this.colors;
        }

        public int[] getFadeColors() {
            return this.fadeColors;
        }

        public boolean isHasTrail() {
            return this.hasTrail;
        }

        public boolean isHasTwinkle() {
            return this.hasTwinkle;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FireworkExplosion)) {
                return false;
            }
            FireworkExplosion other = (FireworkExplosion)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getShapeId() != other.getShapeId()) {
                return false;
            }
            if (this.isHasTrail() != other.isHasTrail()) {
                return false;
            }
            if (this.isHasTwinkle() != other.isHasTwinkle()) {
                return false;
            }
            if (!Arrays.equals(this.getColors(), other.getColors())) {
                return false;
            }
            return Arrays.equals(this.getFadeColors(), other.getFadeColors());
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof FireworkExplosion;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShapeId();
            result = result * 59 + (this.isHasTrail() ? 79 : 97);
            result = result * 59 + (this.isHasTwinkle() ? 79 : 97);
            result = result * 59 + Arrays.hashCode(this.getColors());
            result = result * 59 + Arrays.hashCode(this.getFadeColors());
            return result;
        }

        public @NonNull String toString() {
            return "Fireworks.FireworkExplosion(shapeId=" + this.getShapeId() + ", colors=" + Arrays.toString(this.getColors()) + ", fadeColors=" + Arrays.toString(this.getFadeColors()) + ", hasTrail=" + this.isHasTrail() + ", hasTwinkle=" + this.isHasTwinkle() + ")";
        }

        public FireworkExplosion(int shapeId, int[] colors, int[] fadeColors, boolean hasTrail, boolean hasTwinkle) {
            this.shapeId = shapeId;
            this.colors = colors;
            this.fadeColors = fadeColors;
            this.hasTrail = hasTrail;
            this.hasTwinkle = hasTwinkle;
        }

        public static class FireworkExplosionBuilder {
            private int shapeId;
            private int[] colors;
            private int[] fadeColors;
            private boolean hasTrail;
            private boolean hasTwinkle;

            FireworkExplosionBuilder() {
            }

            public @NonNull FireworkExplosionBuilder shapeId(int shapeId) {
                this.shapeId = shapeId;
                return this;
            }

            public @NonNull FireworkExplosionBuilder colors(int[] colors) {
                this.colors = colors;
                return this;
            }

            public @NonNull FireworkExplosionBuilder fadeColors(int[] fadeColors) {
                this.fadeColors = fadeColors;
                return this;
            }

            public @NonNull FireworkExplosionBuilder hasTrail(boolean hasTrail) {
                this.hasTrail = hasTrail;
                return this;
            }

            public @NonNull FireworkExplosionBuilder hasTwinkle(boolean hasTwinkle) {
                this.hasTwinkle = hasTwinkle;
                return this;
            }

            public @NonNull FireworkExplosion build() {
                return new FireworkExplosion(this.shapeId, this.colors, this.fadeColors, this.hasTrail, this.hasTwinkle);
            }

            public @NonNull String toString() {
                return "Fireworks.FireworkExplosion.FireworkExplosionBuilder(shapeId=" + this.shapeId + ", colors=" + Arrays.toString(this.colors) + ", fadeColors=" + Arrays.toString(this.fadeColors) + ", hasTrail=" + this.hasTrail + ", hasTwinkle=" + this.hasTwinkle + ")";
            }
        }
    }
}

