/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.packet;

import java.util.Set;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketHandler;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacketType;
import org.cloudburstmc.protocol.common.PacketSignal;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;

public class MovementPredictionSyncPacket
implements BedrockPacket {
    private long runtimeEntityId;
    private final Set<EntityFlag> flags = new ObjectOpenHashSet<EntityFlag>();
    private Vector3f boundingBox;
    private float speed;
    private float underwaterSpeed;
    private float lavaSpeed;
    private float jumpStrength;
    private float health;
    private float hunger;

    @Override
    public final PacketSignal handle(BedrockPacketHandler handler) {
        return handler.handle(this);
    }

    @Override
    public BedrockPacketType getPacketType() {
        return BedrockPacketType.MOVEMENT_PREDICTION_SYNC;
    }

    @Override
    public MovementPredictionSyncPacket clone() {
        try {
            return (MovementPredictionSyncPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public long getRuntimeEntityId() {
        return this.runtimeEntityId;
    }

    public Set<EntityFlag> getFlags() {
        return this.flags;
    }

    public Vector3f getBoundingBox() {
        return this.boundingBox;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getUnderwaterSpeed() {
        return this.underwaterSpeed;
    }

    public float getLavaSpeed() {
        return this.lavaSpeed;
    }

    public float getJumpStrength() {
        return this.jumpStrength;
    }

    public float getHealth() {
        return this.health;
    }

    public float getHunger() {
        return this.hunger;
    }

    public void setRuntimeEntityId(long runtimeEntityId) {
        this.runtimeEntityId = runtimeEntityId;
    }

    public void setBoundingBox(Vector3f boundingBox) {
        this.boundingBox = boundingBox;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setUnderwaterSpeed(float underwaterSpeed) {
        this.underwaterSpeed = underwaterSpeed;
    }

    public void setLavaSpeed(float lavaSpeed) {
        this.lavaSpeed = lavaSpeed;
    }

    public void setJumpStrength(float jumpStrength) {
        this.jumpStrength = jumpStrength;
    }

    public void setHealth(float health) {
        this.health = health;
    }

    public void setHunger(float hunger) {
        this.hunger = hunger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MovementPredictionSyncPacket)) {
            return false;
        }
        MovementPredictionSyncPacket other = (MovementPredictionSyncPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.runtimeEntityId != other.runtimeEntityId) {
            return false;
        }
        if (Float.compare(this.speed, other.speed) != 0) {
            return false;
        }
        if (Float.compare(this.underwaterSpeed, other.underwaterSpeed) != 0) {
            return false;
        }
        if (Float.compare(this.lavaSpeed, other.lavaSpeed) != 0) {
            return false;
        }
        if (Float.compare(this.jumpStrength, other.jumpStrength) != 0) {
            return false;
        }
        if (Float.compare(this.health, other.health) != 0) {
            return false;
        }
        if (Float.compare(this.hunger, other.hunger) != 0) {
            return false;
        }
        Set<EntityFlag> this$flags = this.flags;
        Set<EntityFlag> other$flags = other.flags;
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        Vector3f this$boundingBox = this.boundingBox;
        Vector3f other$boundingBox = other.boundingBox;
        return !(this$boundingBox == null ? other$boundingBox != null : !this$boundingBox.equals(other$boundingBox));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MovementPredictionSyncPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $runtimeEntityId = this.runtimeEntityId;
        result = result * 59 + (int)($runtimeEntityId >>> 32 ^ $runtimeEntityId);
        result = result * 59 + Float.floatToIntBits(this.speed);
        result = result * 59 + Float.floatToIntBits(this.underwaterSpeed);
        result = result * 59 + Float.floatToIntBits(this.lavaSpeed);
        result = result * 59 + Float.floatToIntBits(this.jumpStrength);
        result = result * 59 + Float.floatToIntBits(this.health);
        result = result * 59 + Float.floatToIntBits(this.hunger);
        Set<EntityFlag> $flags = this.flags;
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        Vector3f $boundingBox = this.boundingBox;
        result = result * 59 + ($boundingBox == null ? 43 : $boundingBox.hashCode());
        return result;
    }

    public String toString() {
        return "MovementPredictionSyncPacket(runtimeEntityId=" + this.runtimeEntityId + ", flags=" + this.flags + ", boundingBox=" + this.boundingBox + ", speed=" + this.speed + ", underwaterSpeed=" + this.underwaterSpeed + ", lavaSpeed=" + this.lavaSpeed + ", jumpStrength=" + this.jumpStrength + ", health=" + this.health + ", hunger=" + this.hunger + ")";
    }
}

