/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.network.packet;

import io.netty.buffer.ByteBuf;
import org.geysermc.mcprotocollib.network.packet.PacketHeader;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class DefaultPacketHeader
implements PacketHeader {
    @Override
    public boolean isLengthVariable() {
        return true;
    }

    @Override
    public int getLengthSize() {
        return 5;
    }

    @Override
    public int getLengthSize(int length) {
        if ((length & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((length & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((length & 0xFFE00000) == 0) {
            return 3;
        }
        if ((length & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    @Override
    public int readLength(ByteBuf buf, int available) {
        return MinecraftTypes.readVarInt(buf);
    }

    @Override
    public void writeLength(ByteBuf buf, int length) {
        MinecraftTypes.writeVarInt(buf, length);
    }

    @Override
    public int readPacketId(ByteBuf buf) {
        return MinecraftTypes.readVarInt(buf);
    }

    @Override
    public void writePacketId(ByteBuf buf, int packetId) {
        MinecraftTypes.writeVarInt(buf, packetId);
    }
}

