/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.properties.type;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.entity.property.type.GeyserIntEntityProperty;
import org.geysermc.geyser.api.util.Identifier;
import org.geysermc.geyser.entity.properties.type.PropertyType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.entity.IntEntityProperty;

public final class IntProperty
extends Record
implements PropertyType<Integer, IntEntityProperty>,
GeyserIntEntityProperty {
    private final Identifier identifier;
    private final int max;
    private final int min;
    private final @Nullable Integer defaultValue;

    public IntProperty(Identifier identifier, int max, int min, @Nullable Integer defaultValue) {
        if (min > max) {
            throw new IllegalArgumentException("Cannot create int entity property (%s) with a minimum value (%s) greater than maximum (%s)!".formatted(identifier, min, max));
        }
        if (defaultValue != null && (defaultValue < min || defaultValue > max)) {
            throw new IllegalArgumentException("Cannot create int entity property (%s) with a default value (%s) outside of the range (%s - %s)!".formatted(identifier, defaultValue, min, max));
        }
        if (min < -1000000 || max > 1000000) {
            GeyserImpl.getInstance().getLogger().warning("Using int entity properties with min / max values larger than +- 1 million is not recommended!");
        }
        this.identifier = identifier;
        this.max = max;
        this.min = min;
        this.defaultValue = defaultValue;
    }

    @Override
    public NbtMap nbtMap() {
        return NbtMap.builder().putString("name", this.identifier.toString()).putInt("max", this.max).putInt("min", this.min).putInt("type", 0).build();
    }

    @Override
    public IntEntityProperty defaultValue(int index) {
        return this.createValue(index, this.defaultValue == null ? this.min : this.defaultValue);
    }

    @Override
    public IntEntityProperty createValue(int index, Integer value) {
        if (value == null) {
            return this.defaultValue(index);
        }
        return new IntEntityProperty(index, value);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntProperty.class, "identifier;max;min;defaultValue", "identifier", "max", "min", "defaultValue"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntProperty.class, "identifier;max;min;defaultValue", "identifier", "max", "min", "defaultValue"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntProperty.class, "identifier;max;min;defaultValue", "identifier", "max", "min", "defaultValue"}, this, o);
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public int max() {
        return this.max;
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public @Nullable Integer defaultValue() {
        return this.defaultValue;
    }
}

