/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.registry.JavaRegistries;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.session.cache.tags.GeyserHolderSet;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.MinecraftKey;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.packet.common.clientbound.ClientboundUpdateTagsPacket;

public final class TagCache {
    private final GeyserSession session;
    private final Map<Tag<?>, int[]> tags = new Object2ObjectOpenHashMap();

    public TagCache(GeyserSession session) {
        this.session = session;
    }

    public void loadPacket(ClientboundUpdateTagsPacket packet) {
        Map<Key, Map<Key, int[]>> allTags = packet.getTags();
        GeyserLogger logger = this.session.getGeyser().getLogger();
        this.tags.clear();
        for (Key registryKey : allTags.keySet()) {
            JavaRegistryKey<?> registry = JavaRegistries.fromKey(registryKey);
            if (registry == null) {
                logger.debug("Not loading tags for registry " + String.valueOf(registryKey) + " (registry not listed in JavaRegistries)");
                continue;
            }
            Map<Key, int[]> registryTags = allTags.get(registryKey);
            if (registry == JavaRegistries.BLOCK) {
                int[] convertableToMud = registryTags.get(MinecraftKey.key("convertable_to_mud"));
                boolean emulatePost1_18Logic = convertableToMud != null && convertableToMud.length != 0;
                this.session.setEmulatePost1_18Logic(emulatePost1_18Logic);
                if (logger.isDebug()) {
                    logger.debug("Emulating post 1.18 block predication logic for " + this.session.bedrockUsername() + "? " + emulatePost1_18Logic);
                }
            } else if (registry == JavaRegistries.ITEM) {
                boolean emulatePost1_13Logic = registryTags.get(MinecraftKey.key("signs")).length > 1;
                this.session.setEmulatePost1_13Logic(emulatePost1_13Logic);
                if (logger.isDebug()) {
                    logger.debug("Emulating post 1.13 villager logic for " + this.session.bedrockUsername() + "? " + emulatePost1_13Logic);
                }
            }
            this.loadTags(registryTags, registry, registry == JavaRegistries.ITEM);
        }
    }

    private void loadTags(Map<Key, int[]> packetTags, JavaRegistryKey<?> registry, boolean sort) {
        for (Map.Entry<Key, int[]> tag : packetTags.entrySet()) {
            int[] value = tag.getValue();
            if (sort) {
                Arrays.sort(value);
            }
            this.tags.put(new Tag(registry, tag.getKey()), value);
        }
    }

    public boolean is(@NonNull Tag<?> tag, int id) {
        return TagCache.contains(this.getRaw(tag), id);
    }

    public <T> boolean is(@NonNull Tag<T> tag, @NonNull T object) {
        return TagCache.contains(this.getRaw(tag), tag.registry().networkId(this.session, object));
    }

    public <T> boolean is(@NonNull GeyserHolderSet<T> holderSet, @Nullable T object) {
        if (object == null) {
            return false;
        }
        return TagCache.contains(holderSet.resolveRaw(this), holderSet.getRegistry().networkId(this.session, object));
    }

    public <T> boolean is(@Nullable HolderSet holderSet, @NonNull JavaRegistryKey<T> registry, int id) {
        if (holderSet == null) {
            return false;
        }
        int[] entries = holderSet.resolve(key -> {
            if (key.value().startsWith("#")) {
                key = Key.key((String)key.namespace(), (String)key.value().substring(1));
            }
            return this.getRaw(new Tag(registry, (Key)key));
        });
        return TagCache.contains(entries, id);
    }

    public <T> List<T> get(@NonNull Tag<T> tag) {
        return TagCache.mapRawArray(this.session, this.getRaw(tag), tag.registry());
    }

    public int[] getRaw(@NonNull Tag<?> tag) {
        return this.tags.getOrDefault(tag, IntArrays.EMPTY_ARRAY);
    }

    public static <T> List<T> mapRawArray(GeyserSession session, int[] array, JavaRegistryKey<T> registry) {
        return Arrays.stream(array).mapToObj(i -> registry.value(session, i)).toList();
    }

    private static boolean contains(int[] array, int i) {
        for (int item : array) {
            if (item != i) continue;
            return true;
        }
        return false;
    }
}

