/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.player;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class ServerboundSwingPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final Hand hand;

    public ServerboundSwingPacket(ByteBuf in) {
        this.hand = Hand.from(MinecraftTypes.readVarInt(in));
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeVarInt(out, this.hand.ordinal());
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    @lombok.NonNull
    public Hand getHand() {
        return this.hand;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundSwingPacket)) {
            return false;
        }
        ServerboundSwingPacket other = (ServerboundSwingPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Hand this$hand = this.getHand();
        Hand other$hand = other.getHand();
        return !(this$hand == null ? other$hand != null : !((Object)((Object)this$hand)).equals((Object)other$hand));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundSwingPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Hand $hand = this.getHand();
        result = result * 59 + ($hand == null ? 43 : ((Object)((Object)$hand)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundSwingPacket(hand=" + String.valueOf((Object)this.getHand()) + ")";
    }

    public @NonNull ServerboundSwingPacket withHand(@lombok.NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        return this.hand == hand ? this : new ServerboundSwingPacket(hand);
    }

    public ServerboundSwingPacket(@lombok.NonNull Hand hand) {
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        this.hand = hand;
    }
}

