/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.parser.standard;

import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.component.CommandComponent;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.context.CommandContext;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.context.CommandInput;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.exception.parsing.NumberParseException;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.parser.ArgumentParseResult;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.parser.ParserDescriptor;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.parser.standard.IntegerParser;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.parser.standard.NumberParser;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.type.range.LongRange;
import org.geysermc.geyser.platform.bungeecord.shaded.org.incendo.cloud.type.range.Range;

@API(status=API.Status.STABLE)
public final class LongParser<C>
extends NumberParser<C, Long, LongRange>
implements BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE)
    public static final long DEFAULT_MINIMUM = Long.MIN_VALUE;
    @API(status=API.Status.STABLE)
    public static final long DEFAULT_MAXIMUM = Long.MAX_VALUE;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Long> longParser() {
        return LongParser.longParser(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Long> longParser(long minValue) {
        return ParserDescriptor.of(new LongParser<C>(minValue, Long.MAX_VALUE), Long.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Long> longParser(long minValue, long maxValue) {
        return ParserDescriptor.of(new LongParser<C>(minValue, maxValue), Long.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Long> longComponent() {
        return CommandComponent.builder().parser(LongParser.longParser());
    }

    public LongParser(long min, long max) {
        super(Range.longRange(min, max));
    }

    @Override
    public @NonNull ArgumentParseResult<Long> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidLong((LongRange)this.range())) {
            return ArgumentParseResult.failure(new LongParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(commandInput.readLong());
    }

    @Override
    public boolean hasMax() {
        return ((LongRange)this.range()).maxLong() != Long.MAX_VALUE;
    }

    @Override
    public boolean hasMin() {
        return ((LongRange)this.range()).minLong() != Long.MIN_VALUE;
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return IntegerParser.getSuggestions(this.range(), input);
    }

    @API(status=API.Status.STABLE)
    public static final class LongParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public LongParseException(@NonNull String input, @NonNull LongParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "long";
        }
    }
}

