/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.geyser.level.GeyserAdvancement;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.advancement.Advancement;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSeenAdvancementsPacket;

public class AdvancementsCache {
    private final Map<String, Map<String, Long>> storedAdvancementProgress = new HashMap<String, Map<String, Long>>();
    private final Map<String, GeyserAdvancement> storedAdvancements = new HashMap<String, GeyserAdvancement>();
    private String currentAdvancementCategoryId = null;
    private boolean formOpen = false;
    private final GeyserSession session;

    public AdvancementsCache(GeyserSession session) {
        this.session = session;
    }

    public void setCurrentAdvancementCategoryId(String categoryId) {
        if (!Objects.equals(this.currentAdvancementCategoryId, categoryId)) {
            this.currentAdvancementCategoryId = categoryId;
            if (this.formOpen) {
                this.session.closeForm();
                this.buildAndShowForm();
                this.formOpen = true;
            }
        }
    }

    public void buildAndShowForm() {
        if (this.currentAdvancementCategoryId == null) {
            this.buildAndShowMenuForm();
        } else {
            this.buildAndShowListForm();
        }
    }

    public void buildAndShowMenuForm() {
        SimpleForm.Builder builder = (SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().translator(MinecraftLocale::getLocaleString, this.session.locale())).title("gui.advancements");
        ArrayList<String> rootAdvancementIds = new ArrayList<String>();
        for (Map.Entry<String, GeyserAdvancement> advancement : this.storedAdvancements.entrySet()) {
            if (advancement.getValue().getParentId() != null) continue;
            builder.button(MessageTranslator.convertMessage(advancement.getValue().getDisplayData().getTitle(), this.session.locale()));
            rootAdvancementIds.add(advancement.getKey());
        }
        if (rootAdvancementIds.isEmpty()) {
            builder.content("advancements.empty");
        }
        ((SimpleForm.Builder)builder.closedResultHandler(() -> {
            this.formOpen = false;
        })).validResultHandler(response -> {
            String id = (String)rootAdvancementIds.get(response.clickedButtonId());
            if (!id.isEmpty()) {
                ServerboundSeenAdvancementsPacket packet = new ServerboundSeenAdvancementsPacket(id);
                this.session.sendDownstreamGamePacket(packet);
                this.currentAdvancementCategoryId = id;
                this.buildAndShowListForm();
            }
        });
        this.formOpen = true;
        this.session.sendForm(builder);
    }

    public void buildAndShowListForm() {
        GeyserAdvancement categoryAdvancement = this.storedAdvancements.get(this.currentAdvancementCategoryId);
        String language = this.session.locale();
        SimpleForm.Builder builder = ((SimpleForm.Builder)SimpleForm.builder().title(MessageTranslator.convertMessage(categoryAdvancement.getDisplayData().getTitle(), language))).content(MessageTranslator.convertMessage(categoryAdvancement.getDisplayData().getDescription(), language));
        ArrayList<GeyserAdvancement> visibleAdvancements = new ArrayList<GeyserAdvancement>();
        if (this.currentAdvancementCategoryId != null) {
            for (GeyserAdvancement advancement : this.storedAdvancements.values()) {
                boolean earned = this.isEarned(advancement);
                if (!earned && advancement.getDisplayData().isHidden() || advancement.getParentId() == null || !this.currentAdvancementCategoryId.equals(advancement.getRootId(this))) continue;
                String color = earned ? advancement.getDisplayColor() : "";
                builder.button(color + MessageTranslator.convertMessage(advancement.getDisplayData().getTitle()) + "\n");
                visibleAdvancements.add(advancement);
            }
        }
        builder.button(GeyserLocale.getPlayerLocaleString("gui.back", language));
        ((SimpleForm.Builder)builder.closedResultHandler(() -> {
            this.formOpen = false;
            this.session.sendDownstreamGamePacket(new ServerboundSeenAdvancementsPacket());
        })).validResultHandler(response -> {
            if (response.clickedButtonId() < visibleAdvancements.size()) {
                GeyserAdvancement advancement = (GeyserAdvancement)visibleAdvancements.get(response.clickedButtonId());
                this.buildAndShowInfoForm(advancement);
            } else {
                this.buildAndShowMenuForm();
                this.currentAdvancementCategoryId = null;
                this.session.sendDownstreamGamePacket(new ServerboundSeenAdvancementsPacket());
            }
        });
        this.session.sendForm(builder);
    }

    public void buildAndShowInfoForm(GeyserAdvancement advancement) {
        String language = this.session.locale();
        boolean advancementHasProgress = advancement.getRequirements().size() > 1;
        int advancementProgress = this.getProgress(advancement);
        int advancementRequirements = advancement.getRequirements().size();
        boolean advancementEarned = advancementRequirements > 0 && advancementProgress >= advancementRequirements;
        String earned = advancementEarned ? "yes" : "no";
        String description = this.getColorFromAdvancementFrameType(advancement) + MessageTranslator.convertMessage(advancement.getDisplayData().getDescription(), language);
        String earnedString = GeyserLocale.getPlayerLocaleString("geyser.advancements.earned", language, MinecraftLocale.getLocaleString("gui." + earned, language));
        String content = description + "\n\n\u00a7f" + earnedString + "\n";
        if (advancementHasProgress) {
            String progress = MinecraftLocale.getLocaleString("advancements.progress", language).replaceFirst("%s", String.valueOf(advancementProgress)).replaceFirst("%s", String.valueOf(advancementRequirements));
            content = content + GeyserLocale.getPlayerLocaleString("geyser.advancements.progress", language, progress) + "\n";
        }
        if (!this.currentAdvancementCategoryId.equals(advancement.getParentId())) {
            content = content + GeyserLocale.getPlayerLocaleString("geyser.advancements.parentid", language, MessageTranslator.convertMessage(this.storedAdvancements.get(advancement.getParentId()).getDisplayData().getTitle(), language));
        }
        this.session.sendForm((FormBuilder<?, ?, ?>)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(MessageTranslator.convertMessage(advancement.getDisplayData().getTitle()))).content(content).button(GeyserLocale.getPlayerLocaleString("gui.back", language)).validResultHandler(response -> this.buildAndShowListForm())).closedResultHandler(() -> {
            this.formOpen = false;
            this.session.sendDownstreamGamePacket(new ServerboundSeenAdvancementsPacket());
        }));
    }

    public boolean isEarned(GeyserAdvancement advancement) {
        if (advancement.getRequirements().isEmpty()) {
            return false;
        }
        return this.getProgress(advancement) >= advancement.getRequirements().size();
    }

    public int getProgress(GeyserAdvancement advancement) {
        if (advancement.getRequirements().isEmpty()) {
            return 0;
        }
        int progress = 0;
        Map<String, Long> progressMap = this.storedAdvancementProgress.get(advancement.getId());
        if (progressMap != null) {
            for (List<String> requirements : advancement.getRequirements()) {
                for (String requirement : requirements) {
                    Long obtained = progressMap.get(requirement);
                    if (obtained == null || obtained.equals(-1L)) continue;
                    ++progress;
                }
            }
        }
        return progress;
    }

    public String getColorFromAdvancementFrameType(GeyserAdvancement advancement) {
        if (advancement.getDisplayData().getAdvancementType() == Advancement.DisplayData.AdvancementType.CHALLENGE) {
            return "\u00a75";
        }
        return "\u00a7a";
    }

    public Map<String, Map<String, Long>> getStoredAdvancementProgress() {
        return this.storedAdvancementProgress;
    }

    public Map<String, GeyserAdvancement> getStoredAdvancements() {
        return this.storedAdvancements;
    }
}

