/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.content.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.commons.httpclient.HeaderStore;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.model.ContentType;
import net.lenni0451.commons.httpclient.utils.stream.MultiInputStream;

public class MultiPartFormContent
extends HttpContent {
    private final String boundary;
    private final List<FormPart> parts = new ArrayList<FormPart>();
    private boolean unknownLength = false;

    public MultiPartFormContent() {
        this("---" + UUID.randomUUID() + "---");
    }

    public MultiPartFormContent(String boundary) {
        super(new ContentType("multipart/form-data; boundary=" + boundary));
        this.boundary = boundary;
    }

    public MultiPartFormContent addPart(String name, HttpContent content) {
        if (content.getLength() < 0) {
            this.unknownLength = true;
        }
        return this.addPart(new FormPart(name, content));
    }

    public MultiPartFormContent addPart(String name, HttpContent content, @Nullable String fileName) {
        if (content.getLength() < 0) {
            this.unknownLength = true;
        }
        return this.addPart(new FormPart(name, content, fileName));
    }

    public MultiPartFormContent addPart(FormPart part) {
        if (part.getContent().getLength() < 0) {
            this.unknownLength = true;
        }
        this.parts.add(part);
        return this;
    }

    @Override
    public boolean canBeStreamedMultipleTimes() {
        return false;
    }

    @Override
    public int getLength() {
        if (this.unknownLength) {
            return -1;
        }
        int boundaryLength = ("--" + this.boundary + "\r\n").getBytes().length;
        int[] length = new int[]{0};
        for (FormPart part : this.parts) {
            length[0] = length[0] + boundaryLength;
            part.forEachHeader(header -> {
                length[0] = length[0] + header.getBytes().length;
            });
            length[0] = length[0] + 2;
            length[0] = length[0] + part.getContent().getLength();
            length[0] = length[0] + 2;
        }
        return length[0] + boundaryLength;
    }

    @Override
    @Nonnull
    protected InputStream compute() throws IOException {
        ArrayDeque<InputStream> partialStreams = new ArrayDeque<InputStream>(this.parts.size() * 4 + 1);
        byte[] lineBreak = "\r\n".getBytes();
        byte[] boundary = ("--" + this.boundary + "\r\n").getBytes();
        byte[] finalBoundary = ("--" + this.boundary + "--").getBytes();
        for (FormPart part : this.parts) {
            partialStreams.add(new ByteArrayInputStream(boundary));
            part.forEachHeader(header -> partialStreams.add(new ByteArrayInputStream(header.getBytes())));
            partialStreams.add(new ByteArrayInputStream(lineBreak));
            partialStreams.add(part.getContent().getAsStream());
            partialStreams.add(new ByteArrayInputStream(lineBreak));
        }
        partialStreams.add(new ByteArrayInputStream(finalBoundary));
        return new MultiInputStream(partialStreams);
    }

    public static class FormPart
    extends HeaderStore<FormPart> {
        private final HttpContent content;

        public FormPart(String name, HttpContent content) {
            this(name, content, null);
        }

        public FormPart(String name, HttpContent content, @Nullable String fileName) {
            this.content = content;
            this.setHeader("Content-Disposition", "form-data; name=\"" + name + "\"" + (fileName == null ? "" : "; filename=\"" + fileName + "\""));
            this.setHeader("Content-Type", content.getType().toString());
        }

        public HttpContent getContent() {
            return this.content;
        }

        private void forEachHeader(Consumer<String> consumer) {
            this.forEachHeader((String key, String value) -> consumer.accept(key + ": " + value + "\r\n"));
        }
    }
}

