/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.content.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.lenni0451.commons.httpclient.constants.ContentTypes;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.utils.URLCoder;

public class URLEncodedFormContent
extends HttpContent {
    private final List<FormEntry> entries;
    private final Charset charset;

    public URLEncodedFormContent() {
        this(StandardCharsets.UTF_8);
    }

    public URLEncodedFormContent(Map<String, String> entries) {
        this(entries, StandardCharsets.UTF_8);
    }

    public URLEncodedFormContent(Charset charset) {
        super(ContentTypes.APPLICATION_FORM_URLENCODED);
        this.entries = new ArrayList<FormEntry>();
        this.charset = charset;
    }

    public URLEncodedFormContent(Map<String, String> entries, Charset charset) {
        super(ContentTypes.APPLICATION_FORM_URLENCODED);
        this.entries = entries.entrySet().stream().map(e -> new FormEntry((String)e.getKey(), (String)e.getValue(), charset)).collect(Collectors.toList());
        this.charset = charset;
    }

    public URLEncodedFormContent put(String key, String value) {
        this.entries.add(new FormEntry(key, value, this.charset));
        this.clearCache();
        return this;
    }

    @Override
    public boolean canBeStreamedMultipleTimes() {
        return true;
    }

    @Override
    public int getLength() {
        int length = this.entries.size() - 1;
        for (FormEntry entry : this.entries) {
            length += entry.getLength();
        }
        return length;
    }

    @Override
    @Nonnull
    protected InputStream compute() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.getLength());
        for (int i = 0; i < this.entries.size(); ++i) {
            FormEntry entry = this.entries.get(i);
            baos.write(entry.getKey());
            baos.write(61);
            baos.write(entry.getValue());
            if (i >= this.entries.size() - 1) continue;
            baos.write(38);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private static class FormEntry {
        private final byte[] key;
        private final byte[] value;

        private FormEntry(String key, String value, Charset charset) {
            this.key = URLCoder.encode(key).getBytes(charset);
            this.value = URLCoder.encode(value).getBytes(charset);
        }

        public int getLength() {
            return this.key.length + 1 + this.value.length;
        }

        @Generated
        public byte[] getKey() {
            return this.key;
        }

        @Generated
        public byte[] getValue() {
            return this.value;
        }
    }
}

