/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.retry.handlers;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import javax.annotation.Nullable;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.retry.RetryAction;
import net.lenni0451.commons.httpclient.retry.RetryHandler;

public class RetryAfterRetryHandler
implements RetryHandler {
    @Override
    public RetryAction shouldRetry(HttpResponse response) {
        Long delay;
        Optional<String> retryAfter = response.getFirstHeader("Retry-After");
        if (retryAfter.isPresent() && (delay = this.parseSecondsOrHttpDate(retryAfter.get())) != null && delay > 0L) {
            return RetryAction.waitFor(delay);
        }
        return RetryAction.NO_RETRY;
    }

    @Nullable
    private Long parseSecondsOrHttpDate(String value) {
        try {
            Instant date = Instant.from(DateTimeFormatter.RFC_1123_DATE_TIME.parse(value));
            return date.toEpochMilli() - Instant.now().toEpochMilli();
        }
        catch (DateTimeParseException date) {
            try {
                int seconds = Integer.parseInt(value);
                return (long)seconds * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
    }
}

