/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.request;

import java.net.MalformedURLException;
import java.util.HashMap;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.impl.URLEncodedFormContent;
import net.lenni0451.commons.httpclient.requests.impl.PostRequest;
import net.raphimc.minecraftauth.msa.data.MsaEnvironment;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaDeviceCode;
import net.raphimc.minecraftauth.msa.responsehandler.MsaResponseHandler;

public class MsaDeviceCodeRequest
extends PostRequest
implements MsaResponseHandler<MsaDeviceCode> {
    public MsaDeviceCodeRequest(MsaApplicationConfig applicationConfig) throws MalformedURLException {
        super(applicationConfig.getEnvironment().getDeviceCodeUrl());
        HashMap<String, String> postData = new HashMap<String, String>();
        postData.put("client_id", applicationConfig.getClientId());
        postData.put("scope", applicationConfig.getScope());
        if (applicationConfig.getEnvironment() == MsaEnvironment.LIVE) {
            postData.put("response_type", "device_code");
        }
        this.setContent(new URLEncodedFormContent(postData));
    }

    @Override
    public MsaDeviceCode handle(HttpResponse response, GsonObject json) {
        return new MsaDeviceCode(System.currentTimeMillis() + (long)json.reqInt("expires_in") * 1000L, (long)json.reqInt("interval") * 1000L, json.reqString("device_code"), json.reqString("user_code"), json.reqString("verification_uri"));
    }
}

