/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.msa.service.impl;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import net.lenni0451.commons.httpclient.HttpClient;
import net.raphimc.minecraftauth.msa.exception.MsaRequestException;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaDeviceCode;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.msa.request.MsaDeviceCodeRequest;
import net.raphimc.minecraftauth.msa.request.MsaDeviceCodeTokenRequest;
import net.raphimc.minecraftauth.msa.service.MsaAuthService;

public class DeviceCodeMsaAuthService
extends MsaAuthService {
    private final Consumer<MsaDeviceCode> callback;
    private final int timeoutMs;

    public DeviceCodeMsaAuthService(HttpClient httpClient, MsaApplicationConfig applicationConfig, Consumer<MsaDeviceCode> callback) {
        this(httpClient, applicationConfig, callback, 300000);
    }

    public DeviceCodeMsaAuthService(HttpClient httpClient, MsaApplicationConfig applicationConfig, Consumer<MsaDeviceCode> callback, int timeoutMs) {
        super(httpClient, applicationConfig);
        this.callback = callback;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public MsaToken acquireToken() throws IOException, InterruptedException, TimeoutException {
        MsaDeviceCode deviceCode = this.requestDeviceCode();
        this.callback.accept(deviceCode);
        return this.getToken(deviceCode);
    }

    public MsaDeviceCode requestDeviceCode() throws IOException {
        return (MsaDeviceCode)this.httpClient.executeAndHandle(new MsaDeviceCodeRequest(this.applicationConfig));
    }

    public MsaToken getToken(MsaDeviceCode deviceCode) throws IOException, InterruptedException, TimeoutException {
        long start = System.currentTimeMillis();
        while (!deviceCode.isExpired() && System.currentTimeMillis() - start <= (long)this.timeoutMs) {
            try {
                return (MsaToken)this.httpClient.executeAndHandle(new MsaDeviceCodeTokenRequest(this.applicationConfig, deviceCode));
            }
            catch (MsaRequestException e) {
                if (e.getResponse().getStatusCode() == 400 && e.getError().equals("authorization_pending")) {
                    Thread.sleep(deviceCode.getIntervalMs());
                    continue;
                }
                throw e;
            }
        }
        throw new TimeoutException("Login timed out");
    }
}

