/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.util;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;

public class CryptUtil {
    public static final KeyFactory RSA_KEYFACTORY;
    public static final KeyFactory EC_KEYFACTORY;

    public static ECPublicKey ecPublicKeyFromBase64(String base64) {
        return CryptUtil.ecPublicKeyFromBytes(Base64.getDecoder().decode(base64));
    }

    public static ECPrivateKey ecPrivateKeyFromBase64(String base64) {
        return CryptUtil.ecPrivateKeyFromBytes(Base64.getDecoder().decode(base64));
    }

    public static ECPublicKey ecPublicKeyFromBytes(byte[] bytes) {
        try {
            return (ECPublicKey)EC_KEYFACTORY.generatePublic(new X509EncodedKeySpec(bytes));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not decode public key", e);
        }
    }

    public static ECPrivateKey ecPrivateKeyFromBytes(byte[] bytes) {
        try {
            return (ECPrivateKey)EC_KEYFACTORY.generatePrivate(new PKCS8EncodedKeySpec(bytes));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not decode private key", e);
        }
    }

    public static RSAPublicKey rsaPublicKeyFromBase64(String base64) {
        return CryptUtil.rsaPublicKeyFromBytes(Base64.getDecoder().decode(base64));
    }

    public static RSAPrivateKey rsaPrivateKeyFromBase64(String base64) {
        return CryptUtil.rsaPrivateKeyFromBytes(Base64.getDecoder().decode(base64));
    }

    public static RSAPublicKey rsaPublicKeyFromBytes(byte[] bytes) {
        try {
            return (RSAPublicKey)RSA_KEYFACTORY.generatePublic(new X509EncodedKeySpec(bytes));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not decode public key", e);
        }
    }

    public static RSAPrivateKey rsaPrivateKeyFromBytes(byte[] bytes) {
        try {
            return (RSAPrivateKey)RSA_KEYFACTORY.generatePrivate(new PKCS8EncodedKeySpec(bytes));
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Could not decode private key", e);
        }
    }

    public static KeyPair generateEcdsa256KeyPair() {
        KeyPairGenerator secp256r1 = KeyPairGenerator.getInstance("EC");
        secp256r1.initialize(new ECGenParameterSpec("secp256r1"));
        return secp256r1.generateKeyPair();
    }

    public static KeyPair generateEcdsa384KeyPair() {
        KeyPairGenerator secp384r1 = KeyPairGenerator.getInstance("EC");
        secp384r1.initialize(new ECGenParameterSpec("secp384r1"));
        return secp384r1.generateKeyPair();
    }

    public static byte[] signSha256InP1363Format(ECPrivateKey privateKey, byte[] data) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            Signature ecdsaSignature = Signature.getInstance("SHA256withECDSAinP1363Format");
            ecdsaSignature.initSign(privateKey);
            ecdsaSignature.update(data);
            return ecdsaSignature.sign();
        }
        catch (NoSuchAlgorithmException e) {
            Signature ecdsaSignature = Signature.getInstance("SHA256withECDSA");
            ecdsaSignature.initSign(privateKey);
            ecdsaSignature.update(data);
            byte[] derSignature = ecdsaSignature.sign();
            if (derSignature[0] != 48) {
                throw new IllegalArgumentException("Not a valid DER sequence");
            }
            int idx = 2;
            if (derSignature[idx] != 2) {
                throw new IllegalArgumentException("Expected integer for r");
            }
            byte rLen = derSignature[idx + 1];
            byte[] rBytes = Arrays.copyOfRange(derSignature, idx + 2, idx + 2 + rLen);
            if (derSignature[idx += 2 + rLen] != 2) {
                throw new IllegalArgumentException("Expected integer for s");
            }
            byte sLen = derSignature[idx + 1];
            byte[] sBytes = Arrays.copyOfRange(derSignature, idx + 2, idx + 2 + sLen);
            int size = privateKey.getParams().getOrder().bitLength() / 8;
            byte[] concat = new byte[size * 2];
            System.arraycopy(CryptUtil.toFixedLengthP1363(rBytes, size), 0, concat, 0, size);
            System.arraycopy(CryptUtil.toFixedLengthP1363(sBytes, size), 0, concat, size, size);
            return concat;
        }
    }

    private static byte[] toFixedLengthP1363(byte[] val, int size) {
        if (val.length == size) {
            return val;
        }
        if (val.length == size + 1 && val[0] == 0) {
            return Arrays.copyOfRange(val, 1, val.length);
        }
        if (val.length < size) {
            byte[] padded = new byte[size];
            System.arraycopy(val, 0, padded, size - val.length, val.length);
            return padded;
        }
        throw new IllegalArgumentException("Invalid length for ECDSA integer");
    }

    static {
        try {
            RSA_KEYFACTORY = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not create RSA KeyFactory", e);
        }
        try {
            EC_KEYFACTORY = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not create EllipticCurve KeyFactory", e);
        }
    }
}

