/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.util.jwt;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import net.lenni0451.commons.gson.GsonParser;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.raphimc.minecraftauth.util.Expirable;

public final class Jwt
implements Expirable {
    private final GsonObject header;
    private final GsonObject payload;
    private final byte[] signature;

    public static Jwt parse(String compactJwt) {
        if (compactJwt == null) {
            throw new IllegalArgumentException("JWT string is null");
        }
        String[] parts = compactJwt.split("\\.");
        if (parts.length < 2) {
            throw new IllegalArgumentException("JWT must have at least header and payload");
        }
        GsonObject header = GsonParser.parse(new String(Base64.getUrlDecoder().decode(parts[0]), StandardCharsets.UTF_8)).asObject();
        GsonObject payload = GsonParser.parse(new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8)).asObject();
        byte[] signature = parts.length > 2 ? Base64.getUrlDecoder().decode(parts[2]) : null;
        return new Jwt(header, payload, signature);
    }

    @Override
    public long getExpireTimeMs() {
        if (this.payload.hasNumber("exp")) {
            return this.payload.reqLong("exp") * 1000L;
        }
        return Long.MAX_VALUE;
    }

    @Generated
    public Jwt(GsonObject header, GsonObject payload, byte[] signature) {
        this.header = header;
        this.payload = payload;
        this.signature = signature;
    }

    @Generated
    public GsonObject getHeader() {
        return this.header;
    }

    @Generated
    public GsonObject getPayload() {
        return this.payload;
    }

    @Generated
    public byte[] getSignature() {
        return this.signature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Jwt)) {
            return false;
        }
        Jwt other = (Jwt)o;
        GsonObject this$header = this.getHeader();
        GsonObject other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        GsonObject this$payload = this.getPayload();
        GsonObject other$payload = other.getPayload();
        if (this$payload == null ? other$payload != null : !((Object)this$payload).equals(other$payload)) {
            return false;
        }
        return Arrays.equals(this.getSignature(), other.getSignature());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GsonObject $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        GsonObject $payload = this.getPayload();
        result = result * 59 + ($payload == null ? 43 : ((Object)$payload).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        return result;
    }

    @Generated
    public String toString() {
        return "Jwt(header=" + this.getHeader() + ", payload=" + this.getPayload() + ", signature=" + Arrays.toString(this.getSignature()) + ")";
    }
}

