/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.xbl.request;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import java.util.UUID;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.raphimc.minecraftauth.util.http.content.JsonContent;
import net.raphimc.minecraftauth.xbl.model.XblDeviceToken;
import net.raphimc.minecraftauth.xbl.request.SignedXblPostRequest;
import net.raphimc.minecraftauth.xbl.responsehandler.XblResponseHandler;

public class XblDeviceAuthenticateRequest
extends SignedXblPostRequest
implements XblResponseHandler<XblDeviceToken> {
    public XblDeviceAuthenticateRequest(String deviceType, UUID id, KeyPair ecdsa256KeyPair) throws MalformedURLException {
        super("https://device.auth.xboxlive.com/device/authenticate");
        JsonObject properties = new JsonObject();
        properties.addProperty("DeviceType", deviceType);
        properties.addProperty("Id", "{" + id + "}");
        properties.addProperty("AuthMethod", "ProofOfPossession");
        properties.add("ProofKey", (JsonElement)this.getProofKey((ECPublicKey)ecdsa256KeyPair.getPublic()));
        JsonObject postData = new JsonObject();
        postData.add("Properties", (JsonElement)properties);
        postData.addProperty("RelyingParty", "http://auth.xboxlive.com");
        postData.addProperty("TokenType", "JWT");
        this.setContent(new JsonContent(postData));
        this.setHeader("x-xbl-contract-version", "1");
        this.appendSignatureHeader((ECPrivateKey)ecdsa256KeyPair.getPrivate());
    }

    @Override
    public XblDeviceToken handle(HttpResponse response, GsonObject json) {
        return new XblDeviceToken(Instant.parse(json.reqString("NotAfter")).toEpochMilli(), json.reqString("Token"), json.reqObject("DisplayClaims").reqObject("xdi").reqString("did"));
    }
}

