/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.minecraftauth.xbl.request;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.MalformedURLException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import net.lenni0451.commons.gson.elements.GsonObject;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.raphimc.minecraftauth.msa.model.MsaApplicationConfig;
import net.raphimc.minecraftauth.msa.model.MsaToken;
import net.raphimc.minecraftauth.util.http.content.JsonContent;
import net.raphimc.minecraftauth.xbl.model.XblDeviceToken;
import net.raphimc.minecraftauth.xbl.model.XblSisuTokens;
import net.raphimc.minecraftauth.xbl.model.XblTitleToken;
import net.raphimc.minecraftauth.xbl.model.XblUserToken;
import net.raphimc.minecraftauth.xbl.model.XblXstsToken;
import net.raphimc.minecraftauth.xbl.request.SignedXblPostRequest;
import net.raphimc.minecraftauth.xbl.responsehandler.XblResponseHandler;

public class XblSisuAuthorizeRequest
extends SignedXblPostRequest
implements XblResponseHandler<XblSisuTokens> {
    public XblSisuAuthorizeRequest(MsaApplicationConfig applicationConfig, MsaToken token, XblDeviceToken deviceToken, KeyPair ecdsa256KeyPair, String relyingParty) throws MalformedURLException {
        super("https://sisu.xboxlive.com/authorize");
        if (!applicationConfig.isTitleClientId()) {
            throw new IllegalArgumentException("Client id must be a title client id for XBL SISU authentication");
        }
        JsonObject postData = new JsonObject();
        postData.addProperty("Sandbox", "RETAIL");
        postData.addProperty("UseModernGamertag", Boolean.valueOf(true));
        postData.addProperty("AppId", applicationConfig.getClientId());
        postData.addProperty("AccessToken", "t=" + token.getAccessToken());
        postData.addProperty("DeviceToken", deviceToken.getToken());
        postData.add("ProofKey", (JsonElement)this.getProofKey((ECPublicKey)ecdsa256KeyPair.getPublic()));
        postData.addProperty("RelyingParty", relyingParty);
        this.setContent(new JsonContent(postData));
        this.appendSignatureHeader((ECPrivateKey)ecdsa256KeyPair.getPrivate());
    }

    @Override
    public XblSisuTokens handle(HttpResponse response, GsonObject json) {
        GsonObject userTokenJson = json.reqObject("UserToken");
        GsonObject titleTokenJson = json.reqObject("TitleToken");
        GsonObject xstsTokenJson = json.reqObject("AuthorizationToken");
        return new XblSisuTokens(new XblUserToken(Instant.parse(userTokenJson.reqString("NotAfter")).toEpochMilli(), userTokenJson.reqString("Token"), userTokenJson.reqObject("DisplayClaims").reqArray("xui").get(0).asObject().reqString("uhs")), new XblTitleToken(Instant.parse(titleTokenJson.reqString("NotAfter")).toEpochMilli(), titleTokenJson.reqString("Token"), titleTokenJson.reqObject("DisplayClaims").reqObject("xti").reqString("tid")), new XblXstsToken(Instant.parse(xstsTokenJson.reqString("NotAfter")).toEpochMilli(), xstsTokenJson.reqString("Token"), xstsTokenJson.reqObject("DisplayClaims").reqArray("xui").get(0).asObject().reqString("uhs")));
    }
}

