/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.dialog.input;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.geyser.session.dialog.DialogHolder;
import org.geysermc.geyser.session.dialog.input.DialogInput;
import org.geysermc.geyser.session.dialog.input.DialogInputParseException;
import org.geysermc.geyser.text.GeyserLocale;

public class ParsedInputs {
    public static final ParsedInputs EMPTY = new ParsedInputs(List.of());
    private final Map<DialogInput<?>, Object> values = new LinkedHashMap();
    private final Map<DialogInput<?>, DialogInputParseException> errors = new HashMap();

    public ParsedInputs(List<DialogInput<?>> inputs, CustomFormResponse response) {
        for (DialogInput<?> input : inputs) {
            try {
                this.values.put(input, input.read(response));
            }
            catch (DialogInputParseException exception) {
                this.values.put(input, exception.getPartial());
                this.errors.put(input, exception);
            }
        }
    }

    public ParsedInputs(List<DialogInput<?>> inputs) {
        for (DialogInput<?> input : inputs) {
            this.values.put(input, input.defaultValue());
        }
    }

    public void restore(DialogHolder holder, CustomForm.Builder builder) {
        for (Map.Entry<DialogInput<?>, Object> entry : this.values.entrySet()) {
            DialogInputParseException exception = this.errors.get(entry.getKey());
            if (exception != null) {
                String formattedException = GeyserLocale.getPlayerLocaleString(exception.getMessage(), holder.session().locale(), exception.getValues());
                String error = GeyserLocale.getPlayerLocaleString("geyser.dialogs.input_validation_error", holder.session().locale(), formattedException);
                builder.label("\u00a7c" + error);
                builder.label("\u00a7c" + GeyserLocale.getPlayerLocaleString("geyser.dialogs.input_adjust", holder.session().locale()));
            }
            entry.getKey().addComponent(builder, Optional.of(entry.getValue()));
        }
    }

    public String getSubstitution(String key) {
        for (Map.Entry<DialogInput<?>, Object> entry : this.values.entrySet()) {
            if (!entry.getKey().key.equals(key)) continue;
            return entry.getKey().asSubstitution(entry.getValue());
        }
        return "";
    }

    public NbtMap asNbtMap() {
        NbtMapBuilder builder = NbtMap.builder();
        for (Map.Entry<DialogInput<?>, Object> entry : this.values.entrySet()) {
            entry.getKey().addToMap(builder, entry.getValue());
        }
        return builder.build();
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

