/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.populator;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.geysermc.geyser.GeyserBootstrap;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.platform.velocity.shaded.it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponent;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentType;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponents;

public final class DataComponentRegistryPopulator {
    public static void populate() {
        ObjectArrayList defaultComponents;
        GeyserBootstrap bootstrap = GeyserImpl.getInstance().getBootstrap();
        try (InputStream stream = bootstrap.getResourceOrThrow("mappings/item_data_components.json");){
            JsonElement rootElement = new JsonParser().parse((Reader)new InputStreamReader(stream));
            JsonArray jsonArray = rootElement.getAsJsonArray();
            defaultComponents = new ObjectArrayList(jsonArray.size());
            for (JsonElement element : jsonArray) {
                JsonObject entryObject = element.getAsJsonObject();
                JsonObject components = entryObject.getAsJsonObject("components");
                HashMap map = new HashMap();
                for (Map.Entry componentEntry : components.entrySet()) {
                    String encodedValue = ((JsonElement)componentEntry.getValue()).getAsString();
                    byte[] bytes = Base64.getDecoder().decode(encodedValue);
                    ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
                    int varInt = MinecraftTypes.readVarInt(buf);
                    DataComponentType<?> dataComponentType = DataComponentTypes.from(varInt);
                    DataComponent<?, DataComponentType<?>> dataComponent = dataComponentType.readDataComponent(buf);
                    map.put(dataComponentType, dataComponent);
                }
                defaultComponents.add(new DataComponents((Map<DataComponentType<?>, DataComponent<?, ?>>)ImmutableMap.copyOf(map)));
            }
        }
        catch (Exception e) {
            throw new AssertionError("Unable to load or parse components", e);
        }
        Registries.DEFAULT_DATA_COMPONENTS.set((DataComponents)((Object)defaultComponents));
    }
}

