/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.BitSet;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;

public class ServerboundChatPacket
implements MinecraftPacket {
    @lombok.NonNull
    private final String message;
    private final long timeStamp;
    private final long salt;
    private final byte @Nullable [] signature;
    private final int offset;
    private final BitSet acknowledgedMessages;
    private final int checksum;

    public ServerboundChatPacket(ByteBuf in) {
        this.message = MinecraftTypes.readString(in);
        this.timeStamp = in.readLong();
        this.salt = in.readLong();
        this.signature = MinecraftTypes.readNullable(in, buf -> {
            byte[] signature = new byte[256];
            buf.readBytes(signature);
            return signature;
        });
        this.offset = MinecraftTypes.readVarInt(in);
        this.acknowledgedMessages = MinecraftTypes.readFixedBitSet(in, 20);
        this.checksum = in.readByte();
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeString(out, this.message);
        out.writeLong(this.timeStamp);
        out.writeLong(this.salt);
        MinecraftTypes.writeNullable(out, this.signature, ByteBuf::writeBytes);
        MinecraftTypes.writeVarInt(out, this.offset);
        MinecraftTypes.writeFixedBitSet(out, this.acknowledgedMessages, 20);
        out.writeByte(this.checksum);
    }

    @lombok.NonNull
    public String getMessage() {
        return this.message;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public byte @Nullable [] getSignature() {
        return this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    public BitSet getAcknowledgedMessages() {
        return this.acknowledgedMessages;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerboundChatPacket)) {
            return false;
        }
        ServerboundChatPacket other = (ServerboundChatPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimeStamp() != other.getTimeStamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getChecksum() != other.getChecksum()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        BitSet this$acknowledgedMessages = this.getAcknowledgedMessages();
        BitSet other$acknowledgedMessages = other.getAcknowledgedMessages();
        return !(this$acknowledgedMessages == null ? other$acknowledgedMessages != null : !((Object)this$acknowledgedMessages).equals(other$acknowledgedMessages));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ServerboundChatPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeStamp = this.getTimeStamp();
        result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getChecksum();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        BitSet $acknowledgedMessages = this.getAcknowledgedMessages();
        result = result * 59 + ($acknowledgedMessages == null ? 43 : ((Object)$acknowledgedMessages).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ServerboundChatPacket(message=" + this.getMessage() + ", timeStamp=" + this.getTimeStamp() + ", salt=" + this.getSalt() + ", signature=" + Arrays.toString(this.getSignature()) + ", offset=" + this.getOffset() + ", acknowledgedMessages=" + String.valueOf(this.getAcknowledgedMessages()) + ", checksum=" + this.getChecksum() + ")";
    }

    public @NonNull ServerboundChatPacket withMessage(@lombok.NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return this.message == message ? this : new ServerboundChatPacket(message, this.timeStamp, this.salt, this.signature, this.offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatPacket withTimeStamp(long timeStamp) {
        return this.timeStamp == timeStamp ? this : new ServerboundChatPacket(this.message, timeStamp, this.salt, this.signature, this.offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatPacket withSalt(long salt) {
        return this.salt == salt ? this : new ServerboundChatPacket(this.message, this.timeStamp, salt, this.signature, this.offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatPacket withSignature(byte @Nullable [] signature) {
        return this.signature == signature ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, signature, this.offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatPacket withOffset(int offset) {
        return this.offset == offset ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, this.signature, offset, this.acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatPacket withAcknowledgedMessages(BitSet acknowledgedMessages) {
        return this.acknowledgedMessages == acknowledgedMessages ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, this.signature, this.offset, acknowledgedMessages, this.checksum);
    }

    public @NonNull ServerboundChatPacket withChecksum(int checksum) {
        return this.checksum == checksum ? this : new ServerboundChatPacket(this.message, this.timeStamp, this.salt, this.signature, this.offset, this.acknowledgedMessages, checksum);
    }

    public ServerboundChatPacket(@lombok.NonNull String message, long timeStamp, long salt, byte @Nullable [] signature, int offset, BitSet acknowledgedMessages, int checksum) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
        this.timeStamp = timeStamp;
        this.salt = salt;
        this.signature = signature;
        this.offset = offset;
        this.acknowledgedMessages = acknowledgedMessages;
        this.checksum = checksum;
    }
}

