/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.erosion.util;

import io.netty.buffer.ByteBuf;
import org.cloudburstmc.protocol.common.util.Preconditions;
import org.cloudburstmc.protocol.common.util.VarInts;

public final class BlockPositionIterator {
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int sizeX;
    private final int sizeZ;
    private int i = 0;
    private final int maxI;

    private BlockPositionIterator(int minX, int minY, int minZ, int sizeX, int sizeZ, int maxI) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.sizeX = sizeX;
        this.sizeZ = sizeZ;
        this.maxI = maxI;
    }

    public BlockPositionIterator(ByteBuf buf) {
        this.minX = VarInts.readInt(buf);
        this.minY = VarInts.readInt(buf);
        this.minZ = VarInts.readInt(buf);
        this.sizeX = VarInts.readInt(buf);
        this.sizeZ = VarInts.readInt(buf);
        this.maxI = VarInts.readInt(buf);
    }

    public static BlockPositionIterator fromMinMax(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Preconditions.checkArgument(maxX >= minX, "maxX is not greater than or equal to minX");
        Preconditions.checkArgument(maxY >= minY, "maxY is not greater than or equal to minY");
        Preconditions.checkArgument(maxZ >= minZ, "maxZ is not greater than or equal to minZ");
        int sizeX = maxX - minX + 1;
        int sizeY = maxY - minY + 1;
        int sizeZ = maxZ - minZ + 1;
        int maxI = sizeX * sizeY * sizeZ;
        return new BlockPositionIterator(minX, minY, minZ, sizeX, sizeZ, maxI);
    }

    public boolean hasNext() {
        return this.i < this.maxI;
    }

    public void next() {
        ++this.i;
    }

    public void reset() {
        this.i = 0;
    }

    public int getX() {
        return this.i / this.sizeZ % this.sizeX + this.minX;
    }

    public int getY() {
        return this.i / this.sizeZ / this.sizeX + this.minY;
    }

    public int getZ() {
        return this.i % this.sizeZ + this.minZ;
    }

    public int getIteration() {
        return this.i;
    }

    public int getMaxIterations() {
        return this.maxI;
    }

    public int getIndex(int x, int y, int z) {
        int offsetX = x - this.minX;
        int offsetY = y - this.minY;
        int offsetZ = z - this.minZ;
        if (y >= this.minY && offsetY < this.maxI / (this.sizeX * this.sizeZ) && x >= this.minX && offsetX < this.sizeX && z >= this.minZ && offsetZ < this.sizeZ) {
            return offsetZ + offsetX * this.sizeZ + offsetY * this.sizeX * this.sizeZ;
        }
        return -1;
    }

    public void serialize(ByteBuf buf) {
        VarInts.writeInt(buf, this.minX);
        VarInts.writeInt(buf, this.minY);
        VarInts.writeInt(buf, this.minZ);
        VarInts.writeInt(buf, this.sizeX);
        VarInts.writeInt(buf, this.sizeZ);
        VarInts.writeInt(buf, this.maxI);
    }

    public String toString() {
        return "BlockPositionIterator{minX=" + this.minX + ", minY=" + this.minY + ", minZ=" + this.minZ + ", sizeX=" + this.sizeX + ", sizeZ=" + this.sizeZ + ", i=" + this.i + ", maxI=" + this.maxI + "}";
    }
}

