/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.platform.bungeecord.shaded.net.kyori.adventure.key.Key;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.RegistryEntry;

public class ClientboundRegistryDataPacket
implements MinecraftPacket {
    private final Key registry;
    private final List<RegistryEntry> entries;

    public ClientboundRegistryDataPacket(ByteBuf in) {
        this.registry = MinecraftTypes.readResourceLocation(in);
        this.entries = MinecraftTypes.readList(in, buf -> new RegistryEntry(MinecraftTypes.readResourceLocation(buf), MinecraftTypes.readNullable(buf, MinecraftTypes::readCompoundTag)));
    }

    @Override
    public void serialize(ByteBuf out) {
        MinecraftTypes.writeResourceLocation(out, this.registry);
        MinecraftTypes.writeList(out, this.entries, (buf, entry) -> {
            MinecraftTypes.writeResourceLocation(buf, entry.getId());
            MinecraftTypes.writeNullable(buf, entry.getData(), MinecraftTypes::writeAnyTag);
        });
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public Key getRegistry() {
        return this.registry;
    }

    public List<RegistryEntry> getEntries() {
        return this.entries;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundRegistryDataPacket)) {
            return false;
        }
        ClientboundRegistryDataPacket other = (ClientboundRegistryDataPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Key this$registry = this.getRegistry();
        Key other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        List<RegistryEntry> this$entries = this.getEntries();
        List<RegistryEntry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundRegistryDataPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Key $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        List<RegistryEntry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundRegistryDataPacket(registry=" + String.valueOf(this.getRegistry()) + ", entries=" + String.valueOf(this.getEntries()) + ")";
    }

    public @NonNull ClientboundRegistryDataPacket withRegistry(Key registry) {
        return this.registry == registry ? this : new ClientboundRegistryDataPacket(registry, this.entries);
    }

    public @NonNull ClientboundRegistryDataPacket withEntries(List<RegistryEntry> entries) {
        return this.entries == entries ? this : new ClientboundRegistryDataPacket(this.registry, entries);
    }

    public ClientboundRegistryDataPacket(Key registry, List<RegistryEntry> entries) {
        this.registry = registry;
        this.entries = entries;
    }
}

