/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.biome;

import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;

public final class BiomeMesaSurfaceData {
    private final BlockDefinition clayMaterial;
    private final BlockDefinition hardClayMaterial;
    private final boolean brycePillars;
    private final boolean hasForest;

    public BiomeMesaSurfaceData(BlockDefinition clayMaterial, BlockDefinition hardClayMaterial, boolean brycePillars, boolean hasForest) {
        this.clayMaterial = clayMaterial;
        this.hardClayMaterial = hardClayMaterial;
        this.brycePillars = brycePillars;
        this.hasForest = hasForest;
    }

    public BlockDefinition getClayMaterial() {
        return this.clayMaterial;
    }

    public BlockDefinition getHardClayMaterial() {
        return this.hardClayMaterial;
    }

    public boolean isBrycePillars() {
        return this.brycePillars;
    }

    public boolean isHasForest() {
        return this.hasForest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BiomeMesaSurfaceData)) {
            return false;
        }
        BiomeMesaSurfaceData other = (BiomeMesaSurfaceData)o;
        if (this.isBrycePillars() != other.isBrycePillars()) {
            return false;
        }
        if (this.isHasForest() != other.isHasForest()) {
            return false;
        }
        BlockDefinition this$clayMaterial = this.getClayMaterial();
        BlockDefinition other$clayMaterial = other.getClayMaterial();
        if (this$clayMaterial == null ? other$clayMaterial != null : !this$clayMaterial.equals(other$clayMaterial)) {
            return false;
        }
        BlockDefinition this$hardClayMaterial = this.getHardClayMaterial();
        BlockDefinition other$hardClayMaterial = other.getHardClayMaterial();
        return !(this$hardClayMaterial == null ? other$hardClayMaterial != null : !this$hardClayMaterial.equals(other$hardClayMaterial));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBrycePillars() ? 79 : 97);
        result = result * 59 + (this.isHasForest() ? 79 : 97);
        BlockDefinition $clayMaterial = this.getClayMaterial();
        result = result * 59 + ($clayMaterial == null ? 43 : $clayMaterial.hashCode());
        BlockDefinition $hardClayMaterial = this.getHardClayMaterial();
        result = result * 59 + ($hardClayMaterial == null ? 43 : $hardClayMaterial.hashCode());
        return result;
    }

    public String toString() {
        return "BiomeMesaSurfaceData(clayMaterial=" + this.getClayMaterial() + ", hardClayMaterial=" + this.getHardClayMaterial() + ", brycePillars=" + this.isBrycePillars() + ", hasForest=" + this.isHasForest() + ")";
    }
}

