/*
 * Decompiled with CFR 0.152.
 */
package org.cloudburstmc.protocol.bedrock.data.camera;

import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.camera.CameraEase;
import org.cloudburstmc.protocol.common.NamedDefinition;
import org.cloudburstmc.protocol.common.util.OptionalBoolean;

public class CameraSetInstruction {
    private NamedDefinition preset;
    private EaseData ease;
    private Vector3f pos;
    private Vector2f rot;
    private Vector3f facing;
    private Vector2f viewOffset;
    private Vector3f entityOffset;
    private OptionalBoolean defaultPreset;
    private boolean removeIgnoreStartingValues;

    private static OptionalBoolean $default$defaultPreset() {
        return OptionalBoolean.empty();
    }

    public static CameraSetInstructionBuilder builder() {
        return new CameraSetInstructionBuilder();
    }

    public NamedDefinition getPreset() {
        return this.preset;
    }

    public EaseData getEase() {
        return this.ease;
    }

    public Vector3f getPos() {
        return this.pos;
    }

    public Vector2f getRot() {
        return this.rot;
    }

    public Vector3f getFacing() {
        return this.facing;
    }

    public Vector2f getViewOffset() {
        return this.viewOffset;
    }

    public Vector3f getEntityOffset() {
        return this.entityOffset;
    }

    public OptionalBoolean getDefaultPreset() {
        return this.defaultPreset;
    }

    public boolean isRemoveIgnoreStartingValues() {
        return this.removeIgnoreStartingValues;
    }

    public void setPreset(NamedDefinition preset) {
        this.preset = preset;
    }

    public void setEase(EaseData ease) {
        this.ease = ease;
    }

    public void setPos(Vector3f pos) {
        this.pos = pos;
    }

    public void setRot(Vector2f rot) {
        this.rot = rot;
    }

    public void setFacing(Vector3f facing) {
        this.facing = facing;
    }

    public void setViewOffset(Vector2f viewOffset) {
        this.viewOffset = viewOffset;
    }

    public void setEntityOffset(Vector3f entityOffset) {
        this.entityOffset = entityOffset;
    }

    public void setDefaultPreset(OptionalBoolean defaultPreset) {
        this.defaultPreset = defaultPreset;
    }

    public void setRemoveIgnoreStartingValues(boolean removeIgnoreStartingValues) {
        this.removeIgnoreStartingValues = removeIgnoreStartingValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CameraSetInstruction)) {
            return false;
        }
        CameraSetInstruction other = (CameraSetInstruction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRemoveIgnoreStartingValues() != other.isRemoveIgnoreStartingValues()) {
            return false;
        }
        NamedDefinition this$preset = this.getPreset();
        NamedDefinition other$preset = other.getPreset();
        if (this$preset == null ? other$preset != null : !this$preset.equals(other$preset)) {
            return false;
        }
        EaseData this$ease = this.getEase();
        EaseData other$ease = other.getEase();
        if (this$ease == null ? other$ease != null : !((Object)this$ease).equals(other$ease)) {
            return false;
        }
        Vector3f this$pos = this.getPos();
        Vector3f other$pos = other.getPos();
        if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
            return false;
        }
        Vector2f this$rot = this.getRot();
        Vector2f other$rot = other.getRot();
        if (this$rot == null ? other$rot != null : !this$rot.equals(other$rot)) {
            return false;
        }
        Vector3f this$facing = this.getFacing();
        Vector3f other$facing = other.getFacing();
        if (this$facing == null ? other$facing != null : !this$facing.equals(other$facing)) {
            return false;
        }
        Vector2f this$viewOffset = this.getViewOffset();
        Vector2f other$viewOffset = other.getViewOffset();
        if (this$viewOffset == null ? other$viewOffset != null : !this$viewOffset.equals(other$viewOffset)) {
            return false;
        }
        Vector3f this$entityOffset = this.getEntityOffset();
        Vector3f other$entityOffset = other.getEntityOffset();
        if (this$entityOffset == null ? other$entityOffset != null : !this$entityOffset.equals(other$entityOffset)) {
            return false;
        }
        OptionalBoolean this$defaultPreset = this.getDefaultPreset();
        OptionalBoolean other$defaultPreset = other.getDefaultPreset();
        return !(this$defaultPreset == null ? other$defaultPreset != null : !((Object)this$defaultPreset).equals(other$defaultPreset));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CameraSetInstruction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRemoveIgnoreStartingValues() ? 79 : 97);
        NamedDefinition $preset = this.getPreset();
        result = result * 59 + ($preset == null ? 43 : $preset.hashCode());
        EaseData $ease = this.getEase();
        result = result * 59 + ($ease == null ? 43 : ((Object)$ease).hashCode());
        Vector3f $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        Vector2f $rot = this.getRot();
        result = result * 59 + ($rot == null ? 43 : $rot.hashCode());
        Vector3f $facing = this.getFacing();
        result = result * 59 + ($facing == null ? 43 : $facing.hashCode());
        Vector2f $viewOffset = this.getViewOffset();
        result = result * 59 + ($viewOffset == null ? 43 : $viewOffset.hashCode());
        Vector3f $entityOffset = this.getEntityOffset();
        result = result * 59 + ($entityOffset == null ? 43 : $entityOffset.hashCode());
        OptionalBoolean $defaultPreset = this.getDefaultPreset();
        result = result * 59 + ($defaultPreset == null ? 43 : ((Object)$defaultPreset).hashCode());
        return result;
    }

    public String toString() {
        return "CameraSetInstruction(preset=" + this.getPreset() + ", ease=" + this.getEase() + ", pos=" + this.getPos() + ", rot=" + this.getRot() + ", facing=" + this.getFacing() + ", viewOffset=" + this.getViewOffset() + ", entityOffset=" + this.getEntityOffset() + ", defaultPreset=" + this.getDefaultPreset() + ", removeIgnoreStartingValues=" + this.isRemoveIgnoreStartingValues() + ")";
    }

    public CameraSetInstruction(NamedDefinition preset, EaseData ease, Vector3f pos, Vector2f rot, Vector3f facing, Vector2f viewOffset, Vector3f entityOffset, OptionalBoolean defaultPreset, boolean removeIgnoreStartingValues) {
        this.preset = preset;
        this.ease = ease;
        this.pos = pos;
        this.rot = rot;
        this.facing = facing;
        this.viewOffset = viewOffset;
        this.entityOffset = entityOffset;
        this.defaultPreset = defaultPreset;
        this.removeIgnoreStartingValues = removeIgnoreStartingValues;
    }

    public CameraSetInstruction() {
        this.defaultPreset = CameraSetInstruction.$default$defaultPreset();
    }

    public static class CameraSetInstructionBuilder {
        private NamedDefinition preset;
        private EaseData ease;
        private Vector3f pos;
        private Vector2f rot;
        private Vector3f facing;
        private Vector2f viewOffset;
        private Vector3f entityOffset;
        private boolean defaultPreset$set;
        private OptionalBoolean defaultPreset$value;
        private boolean removeIgnoreStartingValues;

        CameraSetInstructionBuilder() {
        }

        public CameraSetInstructionBuilder preset(NamedDefinition preset) {
            this.preset = preset;
            return this;
        }

        public CameraSetInstructionBuilder ease(EaseData ease) {
            this.ease = ease;
            return this;
        }

        public CameraSetInstructionBuilder pos(Vector3f pos) {
            this.pos = pos;
            return this;
        }

        public CameraSetInstructionBuilder rot(Vector2f rot) {
            this.rot = rot;
            return this;
        }

        public CameraSetInstructionBuilder facing(Vector3f facing) {
            this.facing = facing;
            return this;
        }

        public CameraSetInstructionBuilder viewOffset(Vector2f viewOffset) {
            this.viewOffset = viewOffset;
            return this;
        }

        public CameraSetInstructionBuilder entityOffset(Vector3f entityOffset) {
            this.entityOffset = entityOffset;
            return this;
        }

        public CameraSetInstructionBuilder defaultPreset(OptionalBoolean defaultPreset) {
            this.defaultPreset$value = defaultPreset;
            this.defaultPreset$set = true;
            return this;
        }

        public CameraSetInstructionBuilder removeIgnoreStartingValues(boolean removeIgnoreStartingValues) {
            this.removeIgnoreStartingValues = removeIgnoreStartingValues;
            return this;
        }

        public CameraSetInstruction build() {
            OptionalBoolean defaultPreset$value = this.defaultPreset$value;
            if (!this.defaultPreset$set) {
                defaultPreset$value = CameraSetInstruction.$default$defaultPreset();
            }
            return new CameraSetInstruction(this.preset, this.ease, this.pos, this.rot, this.facing, this.viewOffset, this.entityOffset, defaultPreset$value, this.removeIgnoreStartingValues);
        }

        public String toString() {
            return "CameraSetInstruction.CameraSetInstructionBuilder(preset=" + this.preset + ", ease=" + this.ease + ", pos=" + this.pos + ", rot=" + this.rot + ", facing=" + this.facing + ", viewOffset=" + this.viewOffset + ", entityOffset=" + this.entityOffset + ", defaultPreset$value=" + this.defaultPreset$value + ", removeIgnoreStartingValues=" + this.removeIgnoreStartingValues + ")";
        }
    }

    public static class EaseData {
        private final CameraEase easeType;
        private final float time;

        public EaseData(CameraEase easeType, float time) {
            this.easeType = easeType;
            this.time = time;
        }

        public CameraEase getEaseType() {
            return this.easeType;
        }

        public float getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EaseData)) {
                return false;
            }
            EaseData other = (EaseData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getTime(), other.getTime()) != 0) {
                return false;
            }
            CameraEase this$easeType = this.getEaseType();
            CameraEase other$easeType = other.getEaseType();
            return !(this$easeType == null ? other$easeType != null : !((Object)((Object)this$easeType)).equals((Object)other$easeType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EaseData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getTime());
            CameraEase $easeType = this.getEaseType();
            result = result * 59 + ($easeType == null ? 43 : ((Object)((Object)$easeType)).hashCode());
            return result;
        }

        public String toString() {
            return "CameraSetInstruction.EaseData(easeType=" + (Object)((Object)this.getEaseType()) + ", time=" + this.getTime() + ")";
        }
    }
}

