/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.item.hashing;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.geysermc.geyser.item.hashing.MapHasher;
import org.geysermc.geyser.item.hashing.MinecraftHasher;

@FunctionalInterface
public interface MapBuilder<Type>
extends UnaryOperator<MapHasher<Type>> {
    default public <Casted> MapBuilder<Casted> cast() {
        return builder -> builder.accept(this, casted -> casted);
    }

    public static <Type> MapBuilder<Type> unit() {
        return builder -> builder;
    }

    public static <Type> Function<NbtMap, MapBuilder<Type>> inlineNbtMap() {
        return map -> builder -> {
            for (String key : map.keySet()) {
                Object value = map.get(key);
                if (value instanceof NbtList) {
                    NbtList list = (NbtList)value;
                    builder.acceptConstant(key, MinecraftHasher.NBT_LIST, list);
                    continue;
                }
                map.listenForByte(key, b -> builder.acceptConstant(key, MinecraftHasher.BYTE, b));
                map.listenForShort(key, s -> builder.acceptConstant(key, MinecraftHasher.SHORT, s));
                map.listenForInt(key, i -> builder.acceptConstant(key, MinecraftHasher.INT, i));
                map.listenForLong(key, l -> builder.acceptConstant(key, MinecraftHasher.LONG, l));
                map.listenForFloat(key, f -> builder.acceptConstant(key, MinecraftHasher.FLOAT, Float.valueOf(f)));
                map.listenForDouble(key, d -> builder.acceptConstant(key, MinecraftHasher.DOUBLE, d));
                map.listenForString(key, s -> builder.acceptConstant(key, MinecraftHasher.STRING, s));
                map.listenForCompound(key, compound -> builder.acceptConstant(key, MinecraftHasher.NBT_MAP, compound));
                map.listenForByteArray(key, bytes -> builder.acceptConstant(key, MinecraftHasher.BYTE_ARRAY, bytes));
                map.listenForIntArray(key, ints -> builder.acceptConstant(key, MinecraftHasher.INT_ARRAY, ints));
                map.listenForLongArray(key, longs -> builder.acceptConstant(key, MinecraftHasher.LONG_ARRAY, longs));
            }
            return builder;
        };
    }
}

