/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.text;

import org.geysermc.mcprotocollib.protocol.data.game.scoreboard.TeamColor;

public class ChatColor {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final char ESCAPE = '\u00a7';
    public static final String BLACK = "\u00a70";
    public static final String DARK_BLUE = "\u00a71";
    public static final String DARK_GREEN = "\u00a72";
    public static final String DARK_AQUA = "\u00a73";
    public static final String DARK_RED = "\u00a74";
    public static final String DARK_PURPLE = "\u00a75";
    public static final String GOLD = "\u00a76";
    public static final String GRAY = "\u00a77";
    public static final String DARK_GRAY = "\u00a78";
    public static final String BLUE = "\u00a79";
    public static final String GREEN = "\u00a7a";
    public static final String AQUA = "\u00a7b";
    public static final String RED = "\u00a7c";
    public static final String LIGHT_PURPLE = "\u00a7d";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";
    public static final String OBFUSCATED = "\u00a7k";
    public static final String BOLD = "\u00a7l";
    public static final String STRIKETHROUGH = "\u00a7m";
    public static final String UNDERLINE = "\u00a7n";
    public static final String ITALIC = "\u00a7o";
    public static final String RESET = "\u00a7r";

    public static String toANSI(String string) {
        string = string.replace(BOLD, "\u001b[1m");
        string = string.replace(OBFUSCATED, "\u001b[5m");
        string = string.replace(ITALIC, "\u001b[3m");
        string = string.replace(UNDERLINE, "\u001b[4m");
        string = string.replace(STRIKETHROUGH, "\u001b[9m");
        string = string.replace(RESET, ANSI_RESET);
        string = string.replace(BLACK, "\u001b[0;30m");
        string = string.replace(DARK_BLUE, "\u001b[0;34m");
        string = string.replace(DARK_GREEN, "\u001b[0;32m");
        string = string.replace(DARK_AQUA, "\u001b[0;36m");
        string = string.replace(DARK_RED, "\u001b[0;31m");
        string = string.replace(DARK_PURPLE, "\u001b[0;35m");
        string = string.replace(GOLD, "\u001b[0;33m");
        string = string.replace(GRAY, "\u001b[0;37m");
        string = string.replace(DARK_GRAY, "\u001b[30;1m");
        string = string.replace(BLUE, "\u001b[34;1m");
        string = string.replace(GREEN, "\u001b[32;1m");
        string = string.replace(AQUA, "\u001b[36;1m");
        string = string.replace(RED, "\u001b[31;1m");
        string = string.replace(LIGHT_PURPLE, "\u001b[35;1m");
        string = string.replace(YELLOW, "\u001b[33;1m");
        string = string.replace(WHITE, "\u001b[37;1m");
        return string;
    }

    public static String colorDisplayOrder(int index) {
        return switch (index) {
            case 0 -> BLACK;
            case 1 -> DARK_BLUE;
            case 2 -> DARK_GREEN;
            case 3 -> DARK_AQUA;
            case 4 -> DARK_RED;
            case 5 -> DARK_PURPLE;
            case 6 -> GOLD;
            case 7 -> GRAY;
            case 8 -> DARK_GRAY;
            case 9 -> BLUE;
            case 10 -> GREEN;
            case 11 -> AQUA;
            case 12 -> RED;
            case 13 -> LIGHT_PURPLE;
            case 14 -> YELLOW;
            case 15 -> WHITE;
            case 16 -> OBFUSCATED;
            case 17 -> BOLD;
            default -> ITALIC;
        };
    }

    public static String chatColorFor(TeamColor teamColor) {
        return switch (teamColor) {
            case TeamColor.BLACK -> BLACK;
            case TeamColor.DARK_BLUE -> DARK_BLUE;
            case TeamColor.DARK_GREEN -> DARK_GREEN;
            case TeamColor.DARK_AQUA -> DARK_AQUA;
            case TeamColor.DARK_RED -> DARK_RED;
            case TeamColor.DARK_PURPLE -> DARK_PURPLE;
            case TeamColor.GOLD -> GOLD;
            case TeamColor.GRAY -> GRAY;
            case TeamColor.DARK_GRAY -> DARK_GRAY;
            case TeamColor.BLUE -> BLUE;
            case TeamColor.GREEN -> GREEN;
            case TeamColor.AQUA -> AQUA;
            case TeamColor.RED -> RED;
            case TeamColor.LIGHT_PURPLE -> LIGHT_PURPLE;
            case TeamColor.YELLOW -> YELLOW;
            case TeamColor.WHITE -> WHITE;
            case TeamColor.OBFUSCATED -> OBFUSCATED;
            case TeamColor.BOLD -> BOLD;
            case TeamColor.STRIKETHROUGH, TeamColor.UNDERLINED -> "";
            case TeamColor.ITALIC -> ITALIC;
            default -> RESET;
        };
    }
}

