/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.skin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.geysermc.floodgate.util.WebsocketEventType;
import org.geysermc.geyser.Constants;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.GeyserLogger;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.util.PluginMessageUtils;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public final class FloodgateSkinUploader {
    private final ObjectMapper JACKSON = new ObjectMapper();
    private final List<String> skinQueue = new ArrayList<String>();
    private final GeyserLogger logger;
    private final WebSocketClient client;
    private volatile boolean closed;
    private int id;
    private String verifyCode;
    private int subscribersCount;

    public FloodgateSkinUploader(final GeyserImpl geyser) {
        this.logger = geyser.getLogger();
        this.client = new WebSocketClient(Constants.GLOBAL_API_WS_URI){

            public void onOpen(ServerHandshake handshake) {
                this.setConnectionLostTimeout(11);
                Iterator<String> queueIterator = FloodgateSkinUploader.this.skinQueue.iterator();
                while (this.isOpen() && queueIterator.hasNext()) {
                    this.send(queueIterator.next());
                    queueIterator.remove();
                }
            }

            public void onMessage(String message) {
                try {
                    JsonNode node = FloodgateSkinUploader.this.JACKSON.readTree(message);
                    if (node.has("error")) {
                        FloodgateSkinUploader.this.logger.error("Got an error: " + node.get("error").asText());
                        return;
                    }
                    int typeId = node.get("event_id").asInt();
                    WebsocketEventType type = WebsocketEventType.fromId(typeId);
                    if (type == null) {
                        FloodgateSkinUploader.this.logger.warning(String.format("Got (unknown) type %s. Ensure that Geyser is on the latest version and report this issue!", typeId));
                        return;
                    }
                    block1 : switch (type) {
                        case SUBSCRIBER_CREATED: {
                            FloodgateSkinUploader.this.id = node.get("id").asInt();
                            FloodgateSkinUploader.this.verifyCode = node.get("verify_code").asText();
                            break;
                        }
                        case SUBSCRIBER_COUNT: {
                            FloodgateSkinUploader.this.subscribersCount = node.get("subscribers_count").asInt();
                            break;
                        }
                        case SKIN_UPLOADED: {
                            String xuid;
                            GeyserSession session;
                            if (FloodgateSkinUploader.this.subscribersCount != 1 || (session = geyser.connectionByXuid(xuid = node.get("xuid").asText())) == null) break;
                            if (!node.get("success").asBoolean()) {
                                FloodgateSkinUploader.this.logger.info("Failed to upload skin for " + session.bedrockUsername());
                                return;
                            }
                            JsonNode data = node.get("data");
                            String value = data.get("value").asText();
                            String signature = data.get("signature").asText();
                            byte[] bytes = (value + "\u0000" + signature).getBytes(StandardCharsets.UTF_8);
                            PluginMessageUtils.sendMessage(session, "floodgate:skin", bytes);
                            break;
                        }
                        case LOG_MESSAGE: {
                            String logMessage = node.get("message").asText();
                            switch (node.get("priority").asInt()) {
                                case -1: {
                                    FloodgateSkinUploader.this.logger.debug("Got a message from skin uploader: " + logMessage);
                                    break block1;
                                }
                                case 0: {
                                    FloodgateSkinUploader.this.logger.info("Got a message from skin uploader: " + logMessage);
                                    break block1;
                                }
                                case 1: {
                                    FloodgateSkinUploader.this.logger.error("Got a message from skin uploader: " + logMessage);
                                    break block1;
                                }
                            }
                            FloodgateSkinUploader.this.logger.info(logMessage);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    FloodgateSkinUploader.this.logger.error("Error while receiving a message", e);
                }
            }

            public void onClose(int code, String reason, boolean remote) {
                if (reason != null && !reason.isEmpty()) {
                    try {
                        JsonNode node = FloodgateSkinUploader.this.JACKSON.readTree(reason);
                        if (node.has("info")) {
                            String info = node.get("info").asText();
                            FloodgateSkinUploader.this.logger.debug("Got disconnected from the skin uploader: " + info);
                        }
                        if (node.has("error")) {
                            String error = node.get("error").asText();
                            FloodgateSkinUploader.this.logger.info("Got disconnected from the skin uploader: " + error);
                        }
                    }
                    catch (JsonProcessingException node) {
                    }
                    catch (Exception e) {
                        FloodgateSkinUploader.this.logger.error("Error while handling onClose", e);
                    }
                }
                FloodgateSkinUploader.this.reconnectLater(geyser);
            }

            public void onError(Exception ex) {
                if (ex instanceof UnknownHostException) {
                    FloodgateSkinUploader.this.logger.error("Unable to resolve the skin api! This can be caused by your connection or the skin api being unreachable. " + ex.getMessage());
                    return;
                }
                if (ex instanceof ConnectException || ex instanceof SSLException) {
                    if (FloodgateSkinUploader.this.logger.isDebug()) {
                        FloodgateSkinUploader.this.logger.error("[debug] Got an error", ex);
                    }
                    return;
                }
                FloodgateSkinUploader.this.logger.error("Got an error", ex);
            }
        };
    }

    public void uploadSkin(List<String> chainData, String clientData) {
        String jsonString;
        if (chainData == null || clientData == null) {
            return;
        }
        ObjectNode node = this.JACKSON.createObjectNode();
        ArrayNode chainDataNode = this.JACKSON.createArrayNode();
        chainData.forEach(arg_0 -> ((ArrayNode)chainDataNode).add(arg_0));
        node.set("chain_data", (JsonNode)chainDataNode);
        node.put("client_data", clientData);
        try {
            jsonString = this.JACKSON.writeValueAsString((Object)node);
        }
        catch (Exception e) {
            this.logger.error("Failed to upload skin", e);
            return;
        }
        if (this.client.isOpen()) {
            this.client.send(jsonString);
            return;
        }
        this.skinQueue.add(jsonString);
    }

    private void reconnectLater(GeyserImpl geyser) {
        if (geyser.getScheduledThread().isShutdown() || this.closed) {
            this.logger.info("The skin uploader has been closed");
            return;
        }
        long additionalTime = ThreadLocalRandom.current().nextInt(7);
        geyser.getScheduledThread().schedule(() -> ((WebSocketClient)this.client).reconnect(), 8L + additionalTime, TimeUnit.SECONDS);
    }

    public FloodgateSkinUploader start() {
        this.client.connect();
        return this;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.client.close();
        }
    }

    public int getId() {
        return this.id;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public int getSubscribersCount() {
        return this.subscribersCount;
    }
}

