/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.PlayerInventory;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.ContainerType;
import org.jetbrains.annotations.Range;

public class Container
extends Inventory {
    protected final PlayerInventory playerInventory;
    private final int containerSize;
    private boolean isUsingRealBlock = false;

    public Container(GeyserSession session, String title, int id, int size, ContainerType containerType, PlayerInventory playerInventory, InventoryTranslator translator) {
        super(session, title, id, size, containerType, translator);
        this.playerInventory = playerInventory;
        this.containerSize = this.size + 36;
    }

    @Override
    public GeyserItemStack getItem(int slot) {
        if (slot < this.size) {
            return super.getItem(slot);
        }
        return this.playerInventory.getItem(slot - this.size + 9);
    }

    @Override
    public int getOffsetForHotbar(@Range(from=0L, to=8L) int slot) {
        return this.playerInventory.getOffsetForHotbar(slot) - 9 + this.size;
    }

    @Override
    public void setItem(int slot, @NonNull GeyserItemStack newItem, GeyserSession session) {
        if (slot < this.size) {
            super.setItem(slot, newItem, session);
        } else {
            this.playerInventory.setItem(slot - this.size + 9, newItem, session);
        }
    }

    @Override
    public int getSize() {
        return this.containerSize;
    }

    public void setUsingRealBlock(boolean usingRealBlock, Block block) {
        this.isUsingRealBlock = usingRealBlock;
    }

    public PlayerInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public int getContainerSize() {
        return this.containerSize;
    }

    public boolean isUsingRealBlock() {
        return this.isUsingRealBlock;
    }
}

