/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.chunk.bitarray;

import java.util.Arrays;
import org.cloudburstmc.protocol.common.util.Preconditions;
import org.geysermc.geyser.level.chunk.bitarray.BitArray;
import org.geysermc.geyser.level.chunk.bitarray.BitArrayVersion;
import org.geysermc.geyser.util.MathUtils;

public class Pow2BitArray
implements BitArray {
    private final int[] words;
    private final BitArrayVersion version;
    private final int size;

    Pow2BitArray(BitArrayVersion version, int size, int[] words) {
        this.size = size;
        this.version = version;
        this.words = words;
        int expectedWordsLength = MathUtils.ceil((float)size / (float)version.entriesPerWord);
        if (words.length != expectedWordsLength) {
            throw new IllegalArgumentException("Invalid length given for storage, got: " + words.length + " but expected: " + expectedWordsLength);
        }
    }

    @Override
    public void set(int index, int value) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        Preconditions.checkArgument((value >= 0 && value <= this.version.maxEntryValue ? 1 : 0) != 0, (String)"Invalid value %s", (int)value);
        int bitIndex = index * this.version.bits;
        int arrayIndex = bitIndex >> 5;
        int offset = bitIndex & 0x1F;
        this.words[arrayIndex] = this.words[arrayIndex] & ~(this.version.maxEntryValue << offset) | (value & this.version.maxEntryValue) << offset;
    }

    @Override
    public int get(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.size);
        int bitIndex = index * this.version.bits;
        int arrayIndex = bitIndex >> 5;
        int wordOffset = bitIndex & 0x1F;
        return this.words[arrayIndex] >>> wordOffset & this.version.maxEntryValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int[] getWords() {
        return this.words;
    }

    @Override
    public BitArrayVersion getVersion() {
        return this.version;
    }

    @Override
    public BitArray copy() {
        return new Pow2BitArray(this.version, this.size, Arrays.copyOf(this.words, this.words.length));
    }
}

