/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.level.block.property;

import org.geysermc.geyser.level.block.property.Property;

public final class IntegerProperty
extends Property<Integer> {
    private final int offset;
    private final int valuesCount;

    private IntegerProperty(String name, int low, int high) {
        super(name);
        this.offset = low;
        this.valuesCount = high - low;
    }

    @Override
    public int valuesCount() {
        return this.valuesCount;
    }

    @Override
    public int indexOf(Integer value) {
        return value - this.offset;
    }

    public int low() {
        return this.offset;
    }

    public int high() {
        return this.offset + this.valuesCount;
    }

    public static IntegerProperty create(String name, int low, int high) {
        return new IntegerProperty(name, low, high);
    }
}

