/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.data.game.entity.metadata;

import io.netty.buffer.ByteBuf;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.EntityMetadata;

public class MetadataType<T> {
    protected final int id;
    protected final Reader<T> reader;
    protected final Writer<T> writer;
    protected final EntityMetadataFactory<T> metadataFactory;

    protected MetadataType(int id, Reader<T> reader, Writer<T> writer, EntityMetadataFactory<T> metadataFactory) {
        this.id = id;
        this.reader = reader;
        this.writer = writer;
        this.metadataFactory = metadataFactory;
    }

    public EntityMetadata<T, ? extends MetadataType<T>> readMetadata(ByteBuf input, int id) {
        return this.metadataFactory.create(id, this, this.reader.read(input));
    }

    public void writeMetadata(ByteBuf output, T value) {
        this.writer.write(output, value);
    }

    public int getId() {
        return this.id;
    }

    public Reader<T> getReader() {
        return this.reader;
    }

    public Writer<T> getWriter() {
        return this.writer;
    }

    public EntityMetadataFactory<T> getMetadataFactory() {
        return this.metadataFactory;
    }

    @FunctionalInterface
    public static interface Reader<V> {
        public V read(ByteBuf var1);
    }

    @FunctionalInterface
    public static interface Writer<V> {
        public void write(ByteBuf var1, V var2);
    }

    @FunctionalInterface
    public static interface EntityMetadataFactory<V> {
        public EntityMetadata<V, ? extends MetadataType<V>> create(int var1, MetadataType<V> var2, V var3);
    }

    @FunctionalInterface
    public static interface BasicWriter<V>
    extends Writer<V> {
        @Override
        public void write(ByteBuf var1, V var2);
    }

    @FunctionalInterface
    public static interface BasicReader<V>
    extends Reader<V> {
        @Override
        public V read(ByteBuf var1);
    }
}

