/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.protocol.java;

import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.MinecraftLocale;
import org.geysermc.geyser.translator.protocol.PacketTranslator;
import org.geysermc.geyser.translator.protocol.Translator;
import org.geysermc.geyser.util.CodeOfConductManager;
import org.geysermc.mcprotocollib.protocol.packet.configuration.clientbound.ClientboundCodeOfConductPacket;

@Translator(packet=ClientboundCodeOfConductPacket.class)
public class JavaCodeOfConductTranslator
extends PacketTranslator<ClientboundCodeOfConductPacket> {
    @Override
    public void translate(GeyserSession session, ClientboundCodeOfConductPacket packet) {
        if (session.hasAcceptedCodeOfConduct()) {
            return;
        }
        if (CodeOfConductManager.getInstance().hasAcceptedCodeOfConduct(session, packet.getCodeOfConduct())) {
            session.acceptCodeOfConduct();
            return;
        }
        JavaCodeOfConductTranslator.showCodeOfConductForm(session, packet.getCodeOfConduct());
    }

    private static void showCodeOfConductForm(GeyserSession session, String codeOfConduct) {
        session.prepareForConfigurationForm();
        session.sendForm(((CustomForm.Builder)((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().translator(MinecraftLocale::getLocaleString, session.locale())).title("multiplayer.codeOfConduct.title")).label(codeOfConduct).toggle("multiplayer.codeOfConduct.check").validResultHandler(response -> {
            if (response.asToggle()) {
                CodeOfConductManager.getInstance().saveCodeOfConductAccepted(session, codeOfConduct);
            }
            session.acceptCodeOfConduct();
        })).closedResultHandler(() -> session.disconnect(MinecraftLocale.getLocaleString("multiplayer.disconnect.code_of_conduct", session.locale()))));
    }
}

