/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.mcprotocollib.protocol.packet.ingame.clientbound.entity;

import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftPacket;
import org.geysermc.mcprotocollib.protocol.codec.MinecraftTypes;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EntityEvent;

public class ClientboundEntityEventPacket
implements MinecraftPacket {
    private final int entityId;
    @lombok.NonNull
    private final EntityEvent event;

    public ClientboundEntityEventPacket(ByteBuf in) {
        this.entityId = in.readInt();
        this.event = MinecraftTypes.readEntityEvent(in);
    }

    @Override
    public void serialize(ByteBuf out) {
        out.writeInt(this.entityId);
        MinecraftTypes.writeEntityEvent(out, this.event);
    }

    @Override
    public boolean shouldRunOnGameThread() {
        return true;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @lombok.NonNull
    public EntityEvent getEvent() {
        return this.event;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientboundEntityEventPacket)) {
            return false;
        }
        ClientboundEntityEventPacket other = (ClientboundEntityEventPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        EntityEvent this$event = this.getEvent();
        EntityEvent other$event = other.getEvent();
        return !(this$event == null ? other$event != null : !((Object)((Object)this$event)).equals((Object)other$event));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ClientboundEntityEventPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        EntityEvent $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : ((Object)((Object)$event)).hashCode());
        return result;
    }

    public @NonNull String toString() {
        return "ClientboundEntityEventPacket(entityId=" + this.getEntityId() + ", event=" + String.valueOf((Object)this.getEvent()) + ")";
    }

    public @NonNull ClientboundEntityEventPacket withEntityId(int entityId) {
        return this.entityId == entityId ? this : new ClientboundEntityEventPacket(entityId, this.event);
    }

    public @NonNull ClientboundEntityEventPacket withEvent(@lombok.NonNull EntityEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        return this.event == event ? this : new ClientboundEntityEventPacket(this.entityId, event);
    }

    public ClientboundEntityEventPacket(int entityId, @lombok.NonNull EntityEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.entityId = entityId;
        this.event = event;
    }
}

