/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.session.cache.registry;

import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.level.block.type.Block;
import org.geysermc.geyser.platform.spigot.shaded.net.kyori.adventure.key.Key;
import org.geysermc.geyser.registry.BlockRegistries;
import org.geysermc.geyser.registry.ListRegistry;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.RegistryCache;
import org.geysermc.geyser.session.cache.registry.JavaRegistry;
import org.geysermc.geyser.session.cache.registry.JavaRegistryKey;
import org.geysermc.geyser.util.MinecraftKey;

public class JavaRegistries {
    private static final List<JavaRegistryKey<?>> VALUES = new ArrayList();
    public static final JavaRegistryKey<Block> BLOCK = JavaRegistries.create("block", BlockRegistries.JAVA_BLOCKS, Block::javaId);
    public static final JavaRegistryKey<Item> ITEM = JavaRegistries.create("item", Registries.JAVA_ITEMS, Item::javaId);
    public static final JavaRegistryKey<Enchantment> ENCHANTMENT = JavaRegistries.create("enchantment", RegistryCache::enchantments);

    private static <T> JavaRegistryKey<T> create(String key, JavaRegistryKey.NetworkSerializer<T> networkSerializer, JavaRegistryKey.NetworkDeserializer<T> networkDeserializer) {
        JavaRegistryKey<T> registry = new JavaRegistryKey<T>(MinecraftKey.key(key), networkSerializer, networkDeserializer);
        VALUES.add(registry);
        return registry;
    }

    private static <T> JavaRegistryKey<T> create(String key, ListRegistry<T> registry, RegistryNetworkMapper<T> networkSerializer) {
        return JavaRegistries.create(key, (GeyserSession session, T object) -> networkSerializer.get(object), (GeyserSession session, int id) -> registry.get(id));
    }

    private static <T> JavaRegistryKey<T> create(String key, RegistryGetter<T> getter) {
        return JavaRegistries.create(key, (GeyserSession session, T object) -> getter.get(session.getRegistryCache()).byValue(object), (GeyserSession session, int id) -> getter.get(session.getRegistryCache()).byId(id));
    }

    public static @Nullable JavaRegistryKey<?> fromKey(Key registryKey) {
        for (JavaRegistryKey<?> registry : VALUES) {
            if (!registry.registryKey().equals(registryKey)) continue;
            return registry;
        }
        return null;
    }

    @FunctionalInterface
    static interface RegistryNetworkMapper<T> {
        public int get(T var1);
    }

    @FunctionalInterface
    static interface RegistryGetter<T> {
        public JavaRegistry<T> get(RegistryCache var1);
    }
}

