/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.command.defaults;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Predicate;
import org.geysermc.geyser.api.command.Command;
import org.geysermc.geyser.api.util.TriState;
import org.geysermc.geyser.command.GeyserCommand;
import org.geysermc.geyser.command.GeyserCommandSource;
import org.geysermc.geyser.platform.velocity.shaded.org.incendo.cloud.context.CommandContext;
import org.geysermc.geyser.text.GeyserLocale;

public class HelpCommand
extends GeyserCommand {
    private final String rootCommand;
    private final Collection<GeyserCommand> commands;

    public HelpCommand(String rootCommand, String name, String description, String permission, Map<String, GeyserCommand> commands) {
        super(name, description, permission, TriState.TRUE);
        this.rootCommand = rootCommand;
        this.commands = commands.values();
        this.aliases = Collections.singletonList("?");
    }

    @Override
    public String rootCommand() {
        return this.rootCommand;
    }

    @Override
    public void execute(CommandContext<GeyserCommandSource> context) {
        this.execute(context.sender());
    }

    public void execute(GeyserCommandSource source) {
        boolean bedrockPlayer = source.connection() != null;
        int page = 1;
        int maxPage = 1;
        String translationKey = this.rootCommand.equals("geyser") ? "geyser.commands.help.header" : "geyser.commands.extensions.header";
        String header = GeyserLocale.getPlayerLocaleString(translationKey, source.locale(), page, maxPage);
        source.sendMessage(header);
        this.commands.stream().distinct().filter((Predicate<GeyserCommand>)(bedrockPlayer ? Predicates.alwaysTrue() : cmd -> !cmd.isBedrockOnly())).filter(cmd -> source.hasPermission(cmd.permission())).sorted(Comparator.comparing(Command::name)).forEachOrdered(cmd -> {
            String description = GeyserLocale.getPlayerLocaleString(cmd.description(), source.locale());
            source.sendMessage("\u00a7e/" + this.rootCommand + " " + cmd.name() + "\u00a7f: " + description);
        });
    }
}

