/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.registry.loader;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.api.event.lifecycle.GeyserLoadResourcePacksEvent;
import org.geysermc.geyser.api.pack.PathPackCodec;
import org.geysermc.geyser.api.pack.ResourcePackManifest;
import org.geysermc.geyser.api.pack.UrlPackCodec;
import org.geysermc.geyser.event.type.GeyserDefineResourcePacksEventImpl;
import org.geysermc.geyser.pack.GeyserResourcePack;
import org.geysermc.geyser.pack.GeyserResourcePackManifest;
import org.geysermc.geyser.pack.ResourcePackHolder;
import org.geysermc.geyser.pack.SkullResourcePackManager;
import org.geysermc.geyser.pack.path.GeyserPathPackCodec;
import org.geysermc.geyser.pack.url.GeyserUrlPackCodec;
import org.geysermc.geyser.registry.Registries;
import org.geysermc.geyser.registry.loader.RegistryLoader;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.text.GeyserLocale;
import org.geysermc.geyser.util.FileUtils;
import org.geysermc.geyser.util.WebUtils;

public class ResourcePackLoader
implements RegistryLoader<Path, Map<UUID, ResourcePackHolder>> {
    private static final Cache<String, UrlPackCodec> CACHED_FAILED_PACKS = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();
    static final PathMatcher PACK_MATCHER = FileSystems.getDefault().getPathMatcher("glob:**.{zip,mcpack}");
    private static final boolean SHOW_RESOURCE_PACK_LENGTH_WARNING = Boolean.parseBoolean(System.getProperty("Geyser.ShowResourcePackLengthWarning", "true"));

    @Override
    public Map<UUID, ResourcePackHolder> load(Path directory) {
        List<Path> resourcePacks;
        Object2ObjectOpenHashMap<UUID, ResourcePackHolder> packMap = new Object2ObjectOpenHashMap<UUID, ResourcePackHolder>();
        if (!Files.exists(directory, new LinkOption[0])) {
            try {
                Files.createDirectory(directory, new FileAttribute[0]);
            }
            catch (IOException e) {
                GeyserImpl.getInstance().getLogger().error("Could not create packs directory", e);
            }
        }
        try (Stream<Path> stream = Files.list(directory);){
            resourcePacks = stream.filter(PACK_MATCHER::matches).collect(Collectors.toCollection(ArrayList::new));
        }
        catch (Exception e) {
            GeyserImpl.getInstance().getLogger().error("Could not list packs directory", e);
            resourcePacks = new ArrayList();
        }
        Path skullResourcePack = SkullResourcePackManager.createResourcePack();
        if (skullResourcePack != null) {
            resourcePacks.add(skullResourcePack);
        }
        GeyserLoadResourcePacksEvent event = new GeyserLoadResourcePacksEvent(resourcePacks);
        GeyserImpl.getInstance().eventBus().fire(event);
        for (Path path : event.resourcePacks()) {
            try {
                GeyserResourcePack pack = ResourcePackLoader.readPack(path).build();
                packMap.put(pack.uuid(), ResourcePackHolder.of(pack));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GeyserDefineResourcePacksEventImpl defineEvent = new GeyserDefineResourcePacksEventImpl(packMap);
        GeyserImpl.getInstance().eventBus().fire(defineEvent);
        ResourcePackLoader.cleanupRemotePacks();
        return defineEvent.getPacks();
    }

    public static GeyserResourcePack.Builder readPack(Path path) throws IllegalArgumentException {
        String contentKey;
        if (!PACK_MATCHER.matches(path)) {
            throw new IllegalArgumentException("Resource pack " + String.valueOf(path.getFileName()) + " must be a .zip or .mcpack file!");
        }
        ResourcePackManifest manifest = ResourcePackLoader.readManifest(path, path.getFileName().toString());
        try {
            Path keyFile = path.resolveSibling(path.getFileName().toString() + ".key");
            contentKey = Files.exists(keyFile, new LinkOption[0]) ? Files.readString(keyFile, StandardCharsets.UTF_8) : "";
        }
        catch (IOException e) {
            GeyserImpl.getInstance().getLogger().error("Failed to read content key for resource pack " + String.valueOf(path.getFileName()), e);
            contentKey = "";
        }
        return new GeyserResourcePack.Builder(new GeyserPathPackCodec(path), manifest, contentKey);
    }

    public static GeyserResourcePack.Builder readPack(GeyserUrlPackCodec codec) throws IllegalArgumentException {
        Path path = codec.getFallback().path();
        ResourcePackManifest manifest = ResourcePackLoader.readManifest(path, codec.url());
        return new GeyserResourcePack.Builder(codec, manifest);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ResourcePackManifest readManifest(Path path, String packLocation) throws IllegalArgumentException {
        AtomicReference manifestReference = new AtomicReference();
        try (ZipFile zip = new ZipFile(path.toFile());){
            GeyserResourcePackManifest geyserResourcePackManifest;
            block14: {
                Stream<? extends ZipEntry> stream = zip.stream();
                try {
                    stream.forEach(x -> {
                        String name = x.getName();
                        if (SHOW_RESOURCE_PACK_LENGTH_WARNING && name.length() >= 80) {
                            GeyserImpl.getInstance().getLogger().warning("The resource pack " + packLocation + " has a file in it that meets or exceeds 80 characters in its path (" + name + ", " + name.length() + " characters long). This will cause problems on some Bedrock platforms. Please rename it to be shorter, or reduce the amount of folders needed to get to the file.");
                        }
                        if (name.contains("manifest.json")) {
                            try {
                                GeyserResourcePackManifest manifest = FileUtils.loadJson(zip.getInputStream((ZipEntry)x), GeyserResourcePackManifest.class);
                                if (manifest.header().uuid() != null) {
                                    manifestReference.set(manifest);
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    GeyserResourcePackManifest manifest = (GeyserResourcePackManifest)manifestReference.get();
                    if (manifest == null) {
                        throw new IllegalArgumentException(packLocation + " does not contain a valid pack_manifest.json or manifest.json");
                    }
                    geyserResourcePackManifest = manifest;
                    if (stream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stream.close();
            }
            return geyserResourcePackManifest;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(GeyserLocale.getLocaleStringLog("geyser.resource_pack.broken", packLocation), e);
        }
    }

    private Map<UUID, ResourcePackHolder> loadRemotePacks() {
        GeyserImpl instance = GeyserImpl.getInstance();
        Path cachedDirectory = instance.getBootstrap().getConfigFolder().resolve("cache").resolve("remote_packs");
        if (!Files.exists(cachedDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(cachedDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                instance.getLogger().error("Could not create remote pack cache directory", e);
                return new Object2ObjectOpenHashMap<UUID, ResourcePackHolder>();
            }
        }
        List<String> remotePackUrls = List.of();
        Object2ObjectOpenHashMap<UUID, ResourcePackHolder> packMap = new Object2ObjectOpenHashMap<UUID, ResourcePackHolder>();
        for (String url : remotePackUrls) {
            try {
                GeyserUrlPackCodec codec = new GeyserUrlPackCodec(url);
                GeyserResourcePack pack = codec.create();
                packMap.put(pack.uuid(), ResourcePackHolder.of(pack));
            }
            catch (Throwable e) {
                instance.getLogger().error(GeyserLocale.getLocaleStringLog("geyser.resource_pack.broken", url));
                instance.getLogger().error(e.getMessage());
                if (!instance.getLogger().isDebug()) continue;
                e.printStackTrace();
            }
        }
        return packMap;
    }

    public static void testRemotePack(GeyserSession session, GeyserUrlPackCodec codec, ResourcePackHolder holder) {
        if (CACHED_FAILED_PACKS.getIfPresent((Object)codec.url()) == null) {
            CACHED_FAILED_PACKS.put((Object)codec.url(), (Object)codec);
            GeyserImpl.getInstance().getLogger().warning("Bedrock client (%s, playing on %s) was not able to download the resource pack at %s!".formatted(session.bedrockUsername(), session.getClientData().getDeviceOs().name(), codec.url()));
            if (!((Map)Registries.RESOURCE_PACKS.get()).containsKey(holder.uuid())) {
                GeyserImpl.getInstance().getLogger().warning("Skipping remote resource pack check as pack is not present in global resource pack registry.");
                return;
            }
            codec.testForChanges(holder);
        }
    }

    public static CompletableFuture<@NonNull PathPackCodec> downloadPack(String url, boolean force) throws IllegalArgumentException {
        return CompletableFuture.supplyAsync(() -> {
            Path path;
            try {
                path = WebUtils.downloadRemotePack(url, force);
            }
            catch (Throwable e) {
                throw new CompletionException(e);
            }
            if (!PACK_MATCHER.matches(path)) {
                throw new IllegalArgumentException("Invalid pack format from url %s! Not a .zip or .mcpack file.".formatted(url));
            }
            try (ZipFile zip = new ZipFile(path.toFile());){
                if (zip.stream().noneMatch(x -> x.getName().contains("manifest.json"))) {
                    throw new IllegalArgumentException("The pack at the url " + url + " does not contain a manifest file!");
                }
                if ((zip.getEntry("manifest.json") != null || zip.getEntry("pack_manifest.json") != null) && GeyserImpl.getInstance().getLogger().isDebug()) {
                    GeyserImpl.getInstance().getLogger().info("The remote resource pack from " + url + " contains a manifest.json file at the root of the zip file. This may not work for remote packs, and could cause Bedrock clients to fall back to request the pack from the server. Please put the pack file in a subfolder, and provide that zip in the URL.");
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(GeyserLocale.getLocaleStringLog("geyser.resource_pack.broken", url), e);
            }
            return new GeyserPathPackCodec(path);
        });
    }

    public static void clear() {
        if (Registries.RESOURCE_PACKS.loaded()) {
            ((Map)Registries.RESOURCE_PACKS.get()).clear();
        }
        CACHED_FAILED_PACKS.invalidateAll();
    }

    public static void cleanupRemotePacks() {
        File cacheFolder = GeyserImpl.getInstance().getBootstrap().getConfigFolder().resolve("cache").resolve("remote_packs").toFile();
        if (!cacheFolder.exists()) {
            return;
        }
        int count = 0;
        long expireTime = 3600000L;
        for (File cachedPack : Objects.requireNonNull(cacheFolder.listFiles())) {
            if (cachedPack.lastModified() >= System.currentTimeMillis() - 3600000L) continue;
            cachedPack.delete();
            ++count;
        }
        if (count > 0) {
            GeyserImpl.getInstance().getLogger().debug(String.format("Removed %d cached resource pack files as they are no longer in use!", count));
        }
    }
}

