/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal.horse;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityEventType;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityFlag;
import org.cloudburstmc.protocol.bedrock.data.inventory.ContainerType;
import org.cloudburstmc.protocol.bedrock.packet.EntityEventPacket;
import org.cloudburstmc.protocol.bedrock.packet.UpdateAttributesPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.attribute.GeyserAttributeType;
import org.geysermc.geyser.entity.type.living.animal.AnimalEntity;
import org.geysermc.geyser.input.InputLocksFlag;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.type.Item;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.tags.ItemTag;
import org.geysermc.geyser.session.cache.tags.Tag;
import org.geysermc.geyser.util.InteractionResult;
import org.geysermc.geyser.util.InteractiveTag;
import org.geysermc.mcprotocollib.protocol.data.game.entity.EquipmentSlot;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.ByteEntityMetadata;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.Hand;

public class AbstractHorseEntity
extends AnimalEntity {
    public AbstractHorseEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
        this.dirtyMetadata.put(EntityDataTypes.CONTAINER_SIZE, this.getContainerBaseSize());
        this.setFlag(EntityFlag.WASD_CONTROLLED, true);
    }

    protected int getContainerBaseSize() {
        return 2;
    }

    @Override
    public void spawnEntity() {
        super.spawnEntity();
        UpdateAttributesPacket attributesPacket = new UpdateAttributesPacket();
        attributesPacket.setRuntimeEntityId(this.geyserId);
        attributesPacket.getAttributes().add(GeyserAttributeType.HORSE_JUMP_STRENGTH.getAttribute(0.5f, 2.0f));
        this.session.sendUpstreamPacket(attributesPacket);
    }

    @Override
    public void updateSaddled(boolean saddled) {
        this.setFlag(EntityFlag.CAN_POWER_JUMP, saddled);
        super.updateSaddled(saddled);
        if (this.passengers.contains(this.session.getPlayerEntity())) {
            this.session.setLockInput(InputLocksFlag.JUMP, this.doesJumpDismount());
            this.session.updateInputLocks();
        }
    }

    @Override
    public boolean doesJumpDismount() {
        return !this.getFlag(EntityFlag.SADDLED);
    }

    public void setHorseFlags(ByteEntityMetadata entityMetadata) {
        byte xd = entityMetadata.getPrimitiveValue();
        boolean tamed = (xd & 2) == 2;
        this.setFlag(EntityFlag.TAMED, tamed);
        this.setFlag(EntityFlag.EATING, (xd & 0x10) == 16);
        this.setFlag(EntityFlag.STANDING, (xd & 0x20) == 32);
        int horseFlags = 0;
        horseFlags = (xd & 0x40) == 64 ? horseFlags | 0x80 : horseFlags;
        horseFlags = (xd & 0x10) == 16 && (xd & 0x40) != 64 ? horseFlags | 0x20 : horseFlags;
        this.dirtyMetadata.put(EntityDataTypes.HORSE_FLAGS, horseFlags);
        if ((xd & 0x40) == 64) {
            EntityEventPacket entityEventPacket = new EntityEventPacket();
            entityEventPacket.setRuntimeEntityId(this.geyserId);
            entityEventPacket.setType(EntityEventType.EATING_ITEM);
            entityEventPacket.setData(this.session.getItemMappings().getStoredItems().wheat().getBedrockDefinition().getRuntimeId() << 16);
            this.session.sendUpstreamPacket(entityEventPacket);
        }
        this.dirtyMetadata.put(EntityDataTypes.CONTAINER_TYPE, tamed ? (byte)ContainerType.HORSE.getId() : (byte)0);
    }

    @Override
    protected @Nullable Tag<Item> getFoodTag() {
        return ItemTag.HORSE_FOOD;
    }

    @Override
    protected @NonNull InteractiveTag testMobInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        return this.testHorseInteraction(hand, itemInHand);
    }

    protected final @NonNull InteractiveTag testHorseInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean isBaby = this.isBaby();
        if (!isBaby) {
            if (this.getFlag(EntityFlag.TAMED) && this.session.isSneaking()) {
                return InteractiveTag.OPEN_CONTAINER;
            }
            if (!this.passengers.isEmpty()) {
                return super.testMobInteraction(hand, itemInHand);
            }
        }
        if (!itemInHand.isEmpty()) {
            if (this.canEat(itemInHand)) {
                return InteractiveTag.FEED;
            }
            if (this.testSaddle(itemInHand)) {
                return InteractiveTag.SADDLE;
            }
            if (!this.getFlag(EntityFlag.TAMED)) {
                return InteractiveTag.NONE;
            }
            if (this.testForChest(itemInHand)) {
                return InteractiveTag.ATTACH_CHEST;
            }
            if (this.additionalTestForInventoryOpen(itemInHand) || !isBaby && !this.getFlag(EntityFlag.SADDLED) && itemInHand.is(Items.SADDLE)) {
                return InteractiveTag.OPEN_CONTAINER;
            }
        }
        if (isBaby) {
            return super.testMobInteraction(hand, itemInHand);
        }
        return InteractiveTag.MOUNT;
    }

    @Override
    protected @NonNull InteractionResult mobInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        return this.mobHorseInteract(hand, itemInHand);
    }

    protected final @NonNull InteractionResult mobHorseInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        boolean isBaby = this.isBaby();
        if (!isBaby) {
            if (this.getFlag(EntityFlag.TAMED) && this.session.isSneaking()) {
                return InteractionResult.SUCCESS;
            }
            if (!this.passengers.isEmpty()) {
                return super.mobInteract(hand, itemInHand);
            }
        }
        if (!itemInHand.isEmpty()) {
            if (this.canEat(itemInHand)) {
                if (isBaby) {
                    this.playEntityEvent(EntityEventType.BABY_ANIMAL_FEED);
                }
                return InteractionResult.CONSUME;
            }
            if (this.testSaddle(itemInHand)) {
                return InteractionResult.SUCCESS;
            }
            if (!this.getFlag(EntityFlag.TAMED)) {
                return InteractionResult.SUCCESS;
            }
            if (this.testForChest(itemInHand)) {
                return InteractionResult.SUCCESS;
            }
            if (this.additionalTestForInventoryOpen(itemInHand) || !isBaby && !this.getFlag(EntityFlag.SADDLED) && itemInHand.is(Items.SADDLE)) {
                return InteractionResult.SUCCESS;
            }
        }
        if (isBaby) {
            return super.mobInteract(hand, itemInHand);
        }
        return InteractionResult.SUCCESS;
    }

    protected boolean testSaddle(@NonNull GeyserItemStack itemInHand) {
        return this.isAlive() && !this.getFlag(EntityFlag.BABY) && this.getFlag(EntityFlag.TAMED);
    }

    protected boolean testForChest(@NonNull GeyserItemStack itemInHand) {
        return false;
    }

    protected boolean additionalTestForInventoryOpen(@NonNull GeyserItemStack itemInHand) {
        return itemInHand.asItem().javaIdentifier().endsWith("_horse_armor");
    }

    protected final InteractiveTag testUndeadHorseInteraction(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.getFlag(EntityFlag.TAMED)) {
            return InteractiveTag.NONE;
        }
        if (this.isBaby()) {
            return this.testHorseInteraction(hand, itemInHand);
        }
        if (this.session.isSneaking()) {
            return InteractiveTag.OPEN_CONTAINER;
        }
        if (!this.passengers.isEmpty()) {
            return this.testHorseInteraction(hand, itemInHand);
        }
        if (itemInHand.is(Items.SADDLE)) {
            return InteractiveTag.OPEN_CONTAINER;
        }
        if (this.testSaddle(itemInHand)) {
            return InteractiveTag.SADDLE;
        }
        return InteractiveTag.RIDE_HORSE;
    }

    protected final InteractionResult undeadHorseInteract(@NonNull Hand hand, @NonNull GeyserItemStack itemInHand) {
        if (!this.getFlag(EntityFlag.TAMED)) {
            return InteractionResult.PASS;
        }
        if (this.isBaby()) {
            return this.mobHorseInteract(hand, itemInHand);
        }
        if (this.session.isSneaking()) {
            return InteractionResult.SUCCESS;
        }
        if (!this.passengers.isEmpty()) {
            return this.mobHorseInteract(hand, itemInHand);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected boolean canUseSlot(EquipmentSlot slot) {
        if (slot != EquipmentSlot.SADDLE) {
            return super.canUseSlot(slot);
        }
        return this.isAlive() && !this.isBaby() && this.getFlag(EntityFlag.TAMED);
    }
}

