/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.translator.level.block.entity;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.cloudburstmc.protocol.bedrock.data.definitions.BlockDefinition;
import org.cloudburstmc.protocol.bedrock.packet.UpdateBlockPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.level.block.property.Properties;
import org.geysermc.geyser.level.block.type.BlockState;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.session.cache.SkullCache;
import org.geysermc.geyser.skin.SkinManager;
import org.geysermc.geyser.translator.level.block.entity.BlockEntity;
import org.geysermc.geyser.translator.level.block.entity.BlockEntityTranslator;
import org.geysermc.geyser.translator.level.block.entity.RequiresBlockState;
import org.geysermc.geyser.util.EntityUtils;
import org.geysermc.mcprotocollib.auth.GameProfile;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.ResolvableProfile;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.BlockEntityType;

@BlockEntity(type={BlockEntityType.SKULL})
public class SkullBlockEntityTranslator
extends BlockEntityTranslator
implements RequiresBlockState {
    @Override
    public void translateTag(GeyserSession session, NbtMapBuilder bedrockNbt, NbtMap javaNbt, BlockState blockState) {
        Integer rotation = blockState.getValue(Properties.ROTATION_16);
        if (rotation != null) {
            bedrockNbt.putFloat("Rotation", (float)rotation.intValue() * 22.5f);
        }
        if (blockState.getValue(Properties.POWERED).booleanValue()) {
            bedrockNbt.putBoolean("MouthMoving", true);
        }
    }

    private static List<GameProfile.Property> parseProperties(List<NbtMap> properties) {
        if (properties == null) {
            return null;
        }
        return properties.stream().map(property -> {
            String name = property.getString("name");
            String value = property.getString("value");
            String signature = property.getString("signature");
            return new GameProfile.Property(name, value, signature);
        }).toList();
    }

    public static ResolvableProfile parseResolvableProfile(NbtMap profile) {
        UUID uuid = EntityUtils.uuidFromIntArray(profile.getIntArray("id", null));
        String name = profile.getString("name", null);
        List<GameProfile.Property> properties = SkullBlockEntityTranslator.parseProperties(profile.getList("properties", NbtType.COMPOUND, null));
        GameProfile partialOrStatic = new GameProfile(uuid, name);
        partialOrStatic.setProperties(properties);
        return new ResolvableProfile(partialOrStatic);
    }

    public static @Nullable BlockDefinition translateSkull(GeyserSession session, NbtMap javaNbt, Vector3i blockPosition, BlockState blockState) {
        NbtMap profile = javaNbt.getCompound("profile");
        if (profile.isEmpty()) {
            session.getSkullCache().removeSkull(blockPosition);
            return null;
        }
        CompletableFuture<GameProfile> resolvedFuture = SkinManager.resolveProfile(SkullBlockEntityTranslator.parseResolvableProfile(profile));
        if (resolvedFuture.isDone()) {
            try {
                SkullCache.Skull skull = session.getSkullCache().putSkull(blockPosition, resolvedFuture.get(), blockState);
                if (skull == null) {
                    session.getGeyser().getLogger().debug("Custom skull with invalid profile: " + String.valueOf(blockPosition) + " " + String.valueOf(resolvedFuture.get()));
                    return null;
                }
                return skull.getBlockDefinition();
            }
            catch (InterruptedException | ExecutionException e) {
                session.getGeyser().getLogger().debug("Failed to acquire textures for custom skull: " + String.valueOf(blockPosition) + " " + String.valueOf(javaNbt));
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        resolvedFuture.whenComplete((resolved, throwable) -> {
            if (throwable != null) {
                session.getGeyser().getLogger().debug("Failed resolving profile of player head at: " + String.valueOf(blockPosition) + " " + String.valueOf(javaNbt));
                if (GeyserImpl.getInstance().getConfig().isDebugMode()) {
                    throwable.printStackTrace();
                }
                return;
            }
            session.ensureInEventLoop(() -> SkullBlockEntityTranslator.putSkull(session, blockPosition, resolved, blockState));
        });
        return null;
    }

    private static void putSkull(GeyserSession session, Vector3i blockPosition, GameProfile resolved, BlockState blockState) {
        SkullCache.Skull skull = session.getSkullCache().putSkull(blockPosition, resolved, blockState);
        if (skull != null && skull.getBlockDefinition() != null) {
            UpdateBlockPacket updateBlockPacket = new UpdateBlockPacket();
            updateBlockPacket.setDataLayer(0);
            updateBlockPacket.setBlockPosition(blockPosition);
            updateBlockPacket.setDefinition(skull.getBlockDefinition());
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NEIGHBORS);
            updateBlockPacket.getFlags().add(UpdateBlockPacket.Flag.NETWORK);
            session.sendUpstreamPacket(updateBlockPacket);
        }
    }
}

