/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type.living.animal;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.UUID;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.entity.EntityDataTypes;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.living.AbstractFishEntity;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.metadata.type.IntEntityMetadata;

public class TropicalFishEntity
extends AbstractFishEntity {
    private static final IntList PREDEFINED_VARIANTS = IntList.of(0x7010101, 0x7070001, 185008129, 117441793, 118161664, 65536, 50726144, 67764993, 234882305, 0x4000500, 117441025, 0x1000501, 101253888, 50660352, 918529, 235340288, 918273, 0x4000001, 917504, 459008, 67699456, 0x4040001);
    private static final List<String> VARIANT_NAMES = ImmutableList.of((Object)"kob", (Object)"sunstreak", (Object)"snooper", (Object)"dasher", (Object)"brinely", (Object)"spotty", (Object)"flopper", (Object)"stripey", (Object)"glitter", (Object)"blockfish", (Object)"betty", (Object)"clayfish", (Object[])new String[0]);
    private static final List<String> COLOR_NAMES = ImmutableList.of((Object)"white", (Object)"orange", (Object)"magenta", (Object)"light_blue", (Object)"yellow", (Object)"lime", (Object)"pink", (Object)"gray", (Object)"light_gray", (Object)"cyan", (Object)"purple", (Object)"blue", (Object[])new String[]{"brown", "green", "red", "black"});

    public TropicalFishEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    public void setFishVariant(IntEntityMetadata entityMetadata) {
        int varNumber = entityMetadata.getPrimitiveValue();
        this.dirtyMetadata.put(EntityDataTypes.VARIANT, TropicalFishEntity.getShape(varNumber));
        this.dirtyMetadata.put(EntityDataTypes.MARK_VARIANT, TropicalFishEntity.getPattern(varNumber));
        this.dirtyMetadata.put(EntityDataTypes.COLOR, TropicalFishEntity.getBaseColor(varNumber));
        this.dirtyMetadata.put(EntityDataTypes.COLOR_2, TropicalFishEntity.getPatternColor(varNumber));
    }

    public static int getPackedVariant(int pattern, int baseColor, int patternColor) {
        return pattern & 0xFFFF | (baseColor & 0xFF) << 16 | (patternColor & 0xFF) << 24;
    }

    public static int getShape(int variant) {
        return Math.min(variant & 0xFF, 1);
    }

    public static int getPattern(int variant) {
        return Math.min(variant >> 8 & 0xFF, 5);
    }

    public static byte getBaseColor(int variant) {
        byte color = (byte)(variant >> 16 & 0xFF);
        if (0 > color || color > 15) {
            return 0;
        }
        return color;
    }

    public static byte getPatternColor(int variant) {
        byte color = (byte)(variant >> 24 & 0xFF);
        if (0 > color || color > 15) {
            return 0;
        }
        return color;
    }

    public static String getVariantName(int variant) {
        int id = 6 * TropicalFishEntity.getShape(variant) + TropicalFishEntity.getPattern(variant);
        return VARIANT_NAMES.get(id);
    }

    public static String getColorName(byte colorId) {
        return COLOR_NAMES.get(colorId);
    }

    public static int getPredefinedId(int variant) {
        return PREDEFINED_VARIANTS.indexOf(variant);
    }
}

