/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.entity.type;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.PlaySoundPacket;
import org.geysermc.geyser.entity.EntityDefinition;
import org.geysermc.geyser.entity.type.Entity;
import org.geysermc.geyser.session.GeyserSession;

public class LightningEntity
extends Entity {
    public LightningEntity(GeyserSession session, int entityId, long geyserId, UUID uuid, EntityDefinition<?> definition, Vector3f position, Vector3f motion, float yaw, float pitch, float headYaw) {
        super(session, entityId, geyserId, uuid, definition, position, motion, yaw, pitch, headYaw);
    }

    @Override
    public void spawnEntity() {
        super.spawnEntity();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        PlaySoundPacket thunderPacket = new PlaySoundPacket();
        thunderPacket.setPosition(this.position);
        thunderPacket.setSound("ambient.weather.thunder");
        thunderPacket.setPitch(0.8f + random.nextFloat() * 0.2f);
        thunderPacket.setVolume(10000.0f);
        this.session.sendUpstreamPacket((BedrockPacket)thunderPacket);
        PlaySoundPacket impactPacket = new PlaySoundPacket();
        impactPacket.setPosition(this.position);
        impactPacket.setSound("ambient.weather.lightning.impact");
        impactPacket.setPitch(0.5f + random.nextFloat() * 0.2f);
        impactPacket.setVolume(2.0f);
        this.session.sendUpstreamPacket((BedrockPacket)impactPacket);
    }
}

