/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.impl.camera;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.cloudburstmc.math.vector.Vector2f;
import org.cloudburstmc.math.vector.Vector3f;
import org.cloudburstmc.protocol.bedrock.data.CameraShakeAction;
import org.cloudburstmc.protocol.bedrock.data.CameraShakeType;
import org.cloudburstmc.protocol.bedrock.data.HudElement;
import org.cloudburstmc.protocol.bedrock.data.HudVisibility;
import org.cloudburstmc.protocol.bedrock.data.camera.CameraEase;
import org.cloudburstmc.protocol.bedrock.data.camera.CameraFadeInstruction;
import org.cloudburstmc.protocol.bedrock.data.camera.CameraSetInstruction;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.CameraInstructionPacket;
import org.cloudburstmc.protocol.bedrock.packet.CameraShakePacket;
import org.cloudburstmc.protocol.bedrock.packet.PlayerFogPacket;
import org.cloudburstmc.protocol.bedrock.packet.SetHudPacket;
import org.geysermc.geyser.api.bedrock.camera.CameraData;
import org.geysermc.geyser.api.bedrock.camera.CameraEaseType;
import org.geysermc.geyser.api.bedrock.camera.CameraFade;
import org.geysermc.geyser.api.bedrock.camera.CameraPerspective;
import org.geysermc.geyser.api.bedrock.camera.CameraPosition;
import org.geysermc.geyser.api.bedrock.camera.CameraShake;
import org.geysermc.geyser.api.bedrock.camera.GuiElement;
import org.geysermc.geyser.impl.camera.CameraDefinitions;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;

public class GeyserCameraData
implements CameraData {
    private static final HudElement[] HUD_ELEMENT_VALUES = HudElement.values();
    private static final Set<HudElement> ALL_HUD_ELEMENTS = Set.of(HUD_ELEMENT_VALUES);
    private static final GuiElement[] SPECTATOR_HIDDEN_ELEMENTS = new GuiElement[]{GuiElement.AIR_BUBBLES_BAR, GuiElement.ARMOR, GuiElement.HEALTH, GuiElement.FOOD_BAR, GuiElement.PROGRESS_BAR, GuiElement.TOOL_TIPS};
    private final GeyserSession session;
    private final Set<String> appliedFog = new HashSet<String>();
    private final Set<UUID> cameraLockOwners = new HashSet<UUID>();
    private final Set<GuiElement> hiddenHudElements = new HashSet<GuiElement>();
    private CameraPerspective cameraPerspective;

    public GeyserCameraData(GeyserSession session) {
        this.session = session;
    }

    @Override
    public void clearCameraInstructions() {
        this.cameraPerspective = null;
        CameraInstructionPacket packet = new CameraInstructionPacket();
        packet.setClear(true);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public void forceCameraPerspective(@NonNull CameraPerspective perspective) {
        Objects.requireNonNull(perspective, "perspective cannot be null!");
        if (perspective == this.cameraPerspective) {
            return;
        }
        this.cameraPerspective = perspective;
        CameraInstructionPacket packet = new CameraInstructionPacket();
        CameraSetInstruction setInstruction = new CameraSetInstruction();
        if (perspective == CameraPerspective.FREE) {
            throw new IllegalArgumentException("Cannot force a stationary camera (CameraPerspective#FREE) on the player!Send a CameraPosition with an exact position instead");
        }
        setInstruction.setPreset(CameraDefinitions.getById(perspective.ordinal()));
        packet.setSetInstruction(setInstruction);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public @Nullable CameraPerspective forcedCameraPerspective() {
        return this.cameraPerspective;
    }

    @Override
    public void sendCameraFade(@NonNull CameraFade fade) {
        Objects.requireNonNull(fade, "fade cannot be null!");
        CameraFadeInstruction fadeInstruction = new CameraFadeInstruction();
        fadeInstruction.setColor(fade.color());
        fadeInstruction.setTimeData(new CameraFadeInstruction.TimeData(fade.fadeInSeconds(), fade.fadeHoldSeconds(), fade.fadeOutSeconds()));
        CameraInstructionPacket packet = new CameraInstructionPacket();
        packet.setFadeInstruction(fadeInstruction);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public void sendCameraPosition(@NonNull CameraPosition movement) {
        Vector3f facingPosition;
        Objects.requireNonNull(movement, "movement cannot be null!");
        this.cameraPerspective = CameraPerspective.FREE;
        CameraSetInstruction setInstruction = new CameraSetInstruction();
        CameraEaseType easeType = movement.easeType();
        if (easeType != null) {
            setInstruction.setEase(new CameraSetInstruction.EaseData(CameraEase.fromName((String)easeType.id()), movement.easeSeconds()));
        }
        if ((facingPosition = movement.facingPosition()) != null) {
            setInstruction.setFacing(facingPosition);
        }
        setInstruction.setPos(movement.position());
        setInstruction.setRot(Vector2f.from((float)movement.rotationX(), (float)movement.rotationY()));
        setInstruction.setPreset(CameraDefinitions.getByFunctionality(movement.playerPositionForAudio(), movement.renderPlayerEffects()));
        CameraInstructionPacket packet = new CameraInstructionPacket();
        packet.setSetInstruction(setInstruction);
        CameraFade fade = movement.cameraFade();
        if (fade != null) {
            CameraFadeInstruction fadeInstruction = new CameraFadeInstruction();
            fadeInstruction.setColor(fade.color());
            fadeInstruction.setTimeData(new CameraFadeInstruction.TimeData(fade.fadeInSeconds(), fade.fadeHoldSeconds(), fade.fadeOutSeconds()));
            packet.setFadeInstruction(fadeInstruction);
        }
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public void shakeCamera(float intensity, float duration, @NonNull CameraShake type) {
        Objects.requireNonNull(type, "camera shake type must be non null!");
        CameraShakePacket packet = new CameraShakePacket();
        packet.setIntensity(intensity);
        packet.setDuration(duration);
        packet.setShakeType(type == CameraShake.POSITIONAL ? CameraShakeType.POSITIONAL : CameraShakeType.ROTATIONAL);
        packet.setShakeAction(CameraShakeAction.ADD);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public void stopCameraShake() {
        CameraShakePacket packet = new CameraShakePacket();
        packet.setShakeType(CameraShakeType.POSITIONAL);
        packet.setShakeAction(CameraShakeAction.STOP);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public void sendFog(String ... fogNameSpaces) {
        Collections.addAll(this.appliedFog, fogNameSpaces);
        PlayerFogPacket packet = new PlayerFogPacket();
        packet.getFogStack().addAll(this.appliedFog);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public void removeFog(String ... fogNameSpaces) {
        if (fogNameSpaces.length == 0) {
            this.appliedFog.clear();
        } else {
            for (String id : fogNameSpaces) {
                this.appliedFog.remove(id);
            }
        }
        PlayerFogPacket packet = new PlayerFogPacket();
        packet.getFogStack().addAll(this.appliedFog);
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public @NonNull Set<String> fogEffects() {
        return Set.copyOf(this.appliedFog);
    }

    @Override
    public boolean lockCamera(boolean lock, @NonNull UUID owner) {
        Objects.requireNonNull(owner, "owner cannot be null!");
        if (lock) {
            this.cameraLockOwners.add(owner);
        } else {
            this.cameraLockOwners.remove(owner);
        }
        this.session.lockInputs(this.isCameraLocked(), this.session.entities().isMovementLocked());
        return this.isCameraLocked();
    }

    @Override
    public boolean isCameraLocked() {
        return !this.cameraLockOwners.isEmpty();
    }

    @Override
    public void hideElement(GuiElement ... elements) {
        Objects.requireNonNull(elements);
        SetHudPacket packet = new SetHudPacket();
        packet.setVisibility(HudVisibility.HIDE);
        Set elementSet = packet.getElements();
        for (GuiElement element : elements) {
            this.hiddenHudElements.add(element);
            elementSet.add(HUD_ELEMENT_VALUES[element.id()]);
        }
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public void resetElement(GuiElement ... elements) {
        SetHudPacket packet = new SetHudPacket();
        packet.setVisibility(HudVisibility.RESET);
        Set elementSet = packet.getElements();
        if (elements != null && elements.length != 0) {
            for (GuiElement element : elements) {
                this.hiddenHudElements.remove(element);
                elementSet.add(HUD_ELEMENT_VALUES[element.id()]);
            }
        } else {
            this.hiddenHudElements.clear();
            elementSet.addAll(ALL_HUD_ELEMENTS);
        }
        this.session.sendUpstreamPacket((BedrockPacket)packet);
    }

    @Override
    public boolean isHudElementHidden(@NonNull GuiElement element) {
        Objects.requireNonNull(element);
        return this.hiddenHudElements.contains(element);
    }

    @Override
    public @NonNull Set<GuiElement> hiddenElements() {
        return Collections.unmodifiableSet(this.hiddenHudElements);
    }

    public void handleGameModeChange(boolean currentlySpectator, GameMode newGameMode) {
        if (newGameMode == GameMode.SPECTATOR) {
            if (!currentlySpectator) {
                this.hideElement(SPECTATOR_HIDDEN_ELEMENTS);
            }
        } else if (currentlySpectator) {
            this.resetElement(SPECTATOR_HIDDEN_ELEMENTS);
        }
    }

    public CameraPerspective getCameraPerspective() {
        return this.cameraPerspective;
    }
}

