/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.inventory.updater;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.protocol.bedrock.data.inventory.ItemData;
import org.cloudburstmc.protocol.bedrock.packet.BedrockPacket;
import org.cloudburstmc.protocol.bedrock.packet.InventorySlotPacket;
import org.geysermc.geyser.GeyserImpl;
import org.geysermc.geyser.inventory.AnvilContainer;
import org.geysermc.geyser.inventory.GeyserItemStack;
import org.geysermc.geyser.inventory.Inventory;
import org.geysermc.geyser.inventory.item.BedrockEnchantment;
import org.geysermc.geyser.inventory.updater.InventoryUpdater;
import org.geysermc.geyser.item.Items;
import org.geysermc.geyser.item.enchantment.Enchantment;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.translator.inventory.InventoryTranslator;
import org.geysermc.geyser.translator.text.MessageTranslator;
import org.geysermc.mcprotocollib.network.packet.Packet;
import org.geysermc.mcprotocollib.protocol.data.game.entity.player.GameMode;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.DataComponentTypes;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.HolderSet;
import org.geysermc.mcprotocollib.protocol.data.game.item.component.ItemEnchantments;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundRenameItemPacket;

public class AnvilInventoryUpdater
extends InventoryUpdater {
    public static final AnvilInventoryUpdater INSTANCE = new AnvilInventoryUpdater();
    private static final int MAX_LEVEL_COST = 40;

    @Override
    public void updateInventory(InventoryTranslator translator, GeyserSession session, Inventory inventory) {
        super.updateInventory(translator, session, inventory);
        AnvilContainer anvilContainer = (AnvilContainer)inventory;
        this.updateInventoryState(session, anvilContainer);
        int targetSlot = this.getTargetSlot(anvilContainer, session);
        for (int i = 0; i < translator.size; ++i) {
            int bedrockSlot = translator.javaSlotToBedrock(i);
            if (bedrockSlot == 50) continue;
            if (i == targetSlot) {
                this.updateTargetSlot(translator, session, anvilContainer, targetSlot);
                continue;
            }
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(bedrockSlot);
            slotPacket.setItem(inventory.getItem(i).getItemData(session));
            session.sendUpstreamPacket((BedrockPacket)slotPacket);
        }
    }

    @Override
    public boolean updateSlot(InventoryTranslator translator, GeyserSession session, Inventory inventory, int javaSlot) {
        if (super.updateSlot(translator, session, inventory, javaSlot)) {
            return true;
        }
        AnvilContainer anvilContainer = (AnvilContainer)inventory;
        this.updateInventoryState(session, anvilContainer);
        int lastTargetSlot = anvilContainer.getLastTargetSlot();
        int targetSlot = this.getTargetSlot(anvilContainer, session);
        if (targetSlot != javaSlot) {
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(translator.javaSlotToBedrock(javaSlot));
            slotPacket.setItem(inventory.getItem(javaSlot).getItemData(session));
            session.sendUpstreamPacket((BedrockPacket)slotPacket);
        } else if (lastTargetSlot != javaSlot) {
            InventorySlotPacket slotPacket = new InventorySlotPacket();
            slotPacket.setContainerId(124);
            slotPacket.setSlot(translator.javaSlotToBedrock(lastTargetSlot));
            slotPacket.setItem(inventory.getItem(lastTargetSlot).getItemData(session));
            session.sendUpstreamPacket((BedrockPacket)slotPacket);
        }
        this.updateTargetSlot(translator, session, anvilContainer, targetSlot);
        return true;
    }

    private void updateInventoryState(GeyserSession session, AnvilContainer anvilContainer) {
        GeyserItemStack material;
        GeyserItemStack input = anvilContainer.getInput();
        if (!input.equals(anvilContainer.getLastInput())) {
            anvilContainer.setLastInput(input.copy());
            anvilContainer.setUseJavaLevelCost(false);
            String originalName = MessageTranslator.convertToPlainText((Component)input.getComponent(DataComponentTypes.CUSTOM_NAME), session.locale());
            ServerboundRenameItemPacket renameItemPacket = new ServerboundRenameItemPacket(originalName);
            session.sendDownstreamGamePacket((Packet)renameItemPacket);
            anvilContainer.setNewName(null);
        }
        if (!(material = anvilContainer.getMaterial()).equals(anvilContainer.getLastMaterial())) {
            anvilContainer.setLastMaterial(material.copy());
            anvilContainer.setUseJavaLevelCost(false);
        }
    }

    private int getTargetSlot(AnvilContainer anvilContainer, GeyserSession session) {
        GeyserItemStack input = anvilContainer.getInput();
        GeyserItemStack material = anvilContainer.getMaterial();
        if (!material.isEmpty()) {
            if (!input.isEmpty() && this.isRepairing(input, material, session)) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private void updateTargetSlot(InventoryTranslator translator, GeyserSession session, AnvilContainer anvilContainer, int slot) {
        ItemData itemData = anvilContainer.getItem(slot).getItemData(session);
        itemData = this.hijackRepairCost(session, anvilContainer, itemData);
        if (slot == 0 && this.isRenaming(session, anvilContainer, true)) {
            return;
        }
        anvilContainer.setLastTargetSlot(slot);
        InventorySlotPacket slotPacket = new InventorySlotPacket();
        slotPacket.setContainerId(124);
        slotPacket.setSlot(translator.javaSlotToBedrock(slot));
        slotPacket.setItem(itemData);
        session.sendUpstreamPacket((BedrockPacket)slotPacket);
    }

    private ItemData hijackRepairCost(GeyserSession session, AnvilContainer anvilContainer, ItemData itemData) {
        if (itemData.isNull()) {
            return itemData;
        }
        int newRepairCost = anvilContainer.isUseJavaLevelCost() ? anvilContainer.getJavaLevelCost() : this.calcLevelCost(session, anvilContainer, false);
        int bedrockLevelCost = this.calcLevelCost(session, anvilContainer, true);
        if (bedrockLevelCost == -1) {
            return itemData;
        }
        if ((newRepairCost -= bedrockLevelCost) == 0) {
            return itemData;
        }
        NbtMapBuilder tagBuilder = NbtMap.builder();
        if (itemData.getTag() != null) {
            newRepairCost += itemData.getTag().getInt("RepairCost", 0);
            tagBuilder.putAll((Map)itemData.getTag());
        }
        tagBuilder.put("RepairCost", (Object)newRepairCost);
        return itemData.toBuilder().tag(tagBuilder.build()).build();
    }

    public int calcLevelCost(GeyserSession session, AnvilContainer anvilContainer, boolean bedrock) {
        GeyserItemStack input = anvilContainer.getInput();
        GeyserItemStack material = anvilContainer.getMaterial();
        if (input.isEmpty()) {
            return 0;
        }
        int totalRepairCost = this.getRepairCost(input);
        int cost = 0;
        if (!material.isEmpty()) {
            totalRepairCost += this.getRepairCost(material);
            if (this.isCombining(input, material)) {
                int enchantmentLevelCost;
                if (this.hasDurability(input) && input.getJavaId() == material.getJavaId()) {
                    cost += this.calcMergeRepairCost(input, material);
                }
                if ((enchantmentLevelCost = this.calcMergeEnchantmentCost(session, input, material, bedrock)) != -1) {
                    cost += enchantmentLevelCost;
                } else if (cost == 0) {
                    return -1;
                }
            } else if (this.hasDurability(input) && this.isRepairing(input, material, session)) {
                cost = this.calcRepairLevelCost(input, material);
                if (cost == -1) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        int totalCost = totalRepairCost + cost;
        if (this.isRenaming(session, anvilContainer, bedrock) && cost == 0 && ++totalCost >= 40) {
            totalCost = 39;
        }
        return totalCost;
    }

    private int calcRepairLevelCost(GeyserItemStack input, GeyserItemStack material) {
        int newDamage = this.getDamage(input);
        int unitRepair = Math.min(newDamage, input.asItem().defaultMaxDamage() / 4);
        if (unitRepair <= 0) {
            return -1;
        }
        for (int i = 0; i < material.getAmount(); ++i) {
            if ((unitRepair = Math.min(newDamage -= unitRepair, input.asItem().defaultMaxDamage() / 4)) > 0) continue;
            return i + 1;
        }
        return material.getAmount();
    }

    private int calcMergeRepairCost(GeyserItemStack input, GeyserItemStack material) {
        if (this.getDamage(input) > 0 && this.getDamage(material) < material.asItem().defaultMaxDamage() * 112 / 100) {
            return 2;
        }
        return 0;
    }

    private int calcMergeEnchantmentCost(GeyserSession session, GeyserItemStack input, GeyserItemStack material, boolean bedrock) {
        boolean hasCompatible = false;
        Object2IntMap<Enchantment> combinedEnchantments = this.getEnchantments(session, input);
        int cost = 0;
        for (Object2IntMap.Entry entry : this.getEnchantments(session, material).object2IntEntrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            boolean canApply = this.isEnchantedBook(input) || session.getTagCache().is(enchantment.supportedItems(), input.asItem());
            List<Enchantment> incompatibleEnchantments = enchantment.exclusiveSet().resolve(session);
            for (Enchantment incompatible : incompatibleEnchantments) {
                if (!combinedEnchantments.containsKey((Object)incompatible)) continue;
                canApply = false;
                if (bedrock) continue;
                ++cost;
            }
            if (!canApply && (bedrock || session.getGameMode() != GameMode.CREATIVE)) continue;
            int currentLevel = combinedEnchantments.getOrDefault((Object)enchantment, 0);
            int newLevel = entry.getIntValue();
            if (newLevel == currentLevel) {
                ++newLevel;
            }
            if ((newLevel = Math.max(currentLevel, newLevel)) > enchantment.maxLevel()) {
                newLevel = enchantment.maxLevel();
            }
            combinedEnchantments.put((Object)enchantment, newLevel);
            int rarityMultiplier = enchantment.anvilCost();
            if (this.isEnchantedBook(material) && rarityMultiplier > 1) {
                rarityMultiplier /= 2;
            }
            if (bedrock) {
                if (newLevel > currentLevel) {
                    hasCompatible = true;
                }
                if (enchantment.bedrockEnchantment() == BedrockEnchantment.IMPALING) {
                    rarityMultiplier /= 2;
                } else if (enchantment.bedrockEnchantment() == null) {
                    rarityMultiplier = 0;
                }
                cost += rarityMultiplier * (newLevel - currentLevel);
                continue;
            }
            hasCompatible = true;
            cost += rarityMultiplier * newLevel;
        }
        if (!hasCompatible) {
            return -1;
        }
        return cost;
    }

    private Object2IntMap<Enchantment> getEnchantments(GeyserSession session, GeyserItemStack itemStack) {
        ItemEnchantments enchantmentComponent = this.isEnchantedBook(itemStack) ? (ItemEnchantments)itemStack.getComponent(DataComponentTypes.STORED_ENCHANTMENTS) : (ItemEnchantments)itemStack.getComponent(DataComponentTypes.ENCHANTMENTS);
        if (enchantmentComponent != null) {
            Object2IntOpenHashMap enchantments = new Object2IntOpenHashMap();
            for (Map.Entry entry : enchantmentComponent.getEnchantments().entrySet()) {
                Enchantment enchantment = session.getRegistryCache().enchantments().byId((Integer)entry.getKey());
                if (enchantment == null) {
                    GeyserImpl.getInstance().getLogger().debug("Unknown Java enchantment in anvil: " + String.valueOf(entry.getKey()));
                    continue;
                }
                enchantments.put((Object)enchantment, ((Integer)entry.getValue()).intValue());
            }
            return enchantments;
        }
        return new Object2IntOpenHashMap();
    }

    private boolean isEnchantedBook(GeyserItemStack itemStack) {
        return itemStack.asItem() == Items.ENCHANTED_BOOK;
    }

    private boolean isCombining(GeyserItemStack input, GeyserItemStack material) {
        return this.isEnchantedBook(material) || input.getJavaId() == material.getJavaId() && this.hasDurability(input);
    }

    private boolean isRepairing(GeyserItemStack input, GeyserItemStack material, GeyserSession session) {
        HolderSet repairable = (HolderSet)input.getComponent(DataComponentTypes.REPAIRABLE);
        if (repairable == null) {
            return false;
        }
        return session.getTagCache().isItem(repairable, material.asItem());
    }

    private boolean isRenaming(GeyserSession session, AnvilContainer anvilContainer, boolean bedrock) {
        if (anvilContainer.getResult().isEmpty()) {
            return false;
        }
        Component originalName = (Component)anvilContainer.getInput().getComponent(DataComponentTypes.CUSTOM_NAME);
        if (bedrock && originalName != null && anvilContainer.getNewName() != null) {
            String legacyOriginalName = MessageTranslator.convertMessage(originalName, session.locale());
            return !legacyOriginalName.equals(anvilContainer.getNewName());
        }
        return !Objects.equals(originalName, anvilContainer.getResult().getComponent(DataComponentTypes.CUSTOM_NAME));
    }

    private int getRepairCost(GeyserItemStack itemStack) {
        return itemStack.getComponentElseGet(DataComponentTypes.REPAIR_COST, () -> 0);
    }

    private boolean hasDurability(GeyserItemStack itemStack) {
        if (itemStack.asItem().defaultMaxDamage() > 0) {
            return itemStack.getComponent(DataComponentTypes.UNBREAKABLE) != null;
        }
        return false;
    }

    private int getDamage(GeyserItemStack itemStack) {
        return itemStack.getComponentElseGet(DataComponentTypes.DAMAGE, () -> 0);
    }
}

