/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.util;

import org.cloudburstmc.math.vector.Vector3i;
import org.cloudburstmc.nbt.NbtList;
import org.cloudburstmc.nbt.NbtMap;
import org.cloudburstmc.nbt.NbtMapBuilder;
import org.cloudburstmc.nbt.NbtType;
import org.geysermc.geyser.session.GeyserSession;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureRotation;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureSettings;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureTemplateResponseType;
import org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.packet.StructureTemplateDataResponsePacket;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.UpdateStructureBlockAction;
import org.geysermc.mcprotocollib.protocol.data.game.inventory.UpdateStructureBlockMode;
import org.geysermc.mcprotocollib.protocol.data.game.level.block.StructureMirror;
import org.geysermc.mcprotocollib.protocol.packet.ingame.serverbound.inventory.ServerboundSetStructureBlockPacket;

public class StructureBlockUtils {
    private static final NbtMap EMPTY_STRUCTURE_DATA;

    public static void sendEmptyStructureData(GeyserSession session) {
        StructureTemplateDataResponsePacket responsePacket = new StructureTemplateDataResponsePacket();
        responsePacket.setName("");
        responsePacket.setSave(false);
        responsePacket.setType(StructureTemplateResponseType.QUERY);
        session.sendUpstreamPacket(responsePacket);
    }

    public static void sendStructureData(GeyserSession session, Vector3i size, String name) {
        StructureTemplateDataResponsePacket responsePacket = new StructureTemplateDataResponsePacket();
        responsePacket.setName(name);
        responsePacket.setSave(true);
        responsePacket.setTag(EMPTY_STRUCTURE_DATA.toBuilder().putList("size", NbtType.INT, (Object[])new Integer[]{Math.abs(size.getX()), size.getY(), Math.abs(size.getZ())}).build());
        responsePacket.setType(StructureTemplateResponseType.QUERY);
        session.sendUpstreamPacket(responsePacket);
    }

    public static Vector3i calculateOffset(StructureRotation structureRotation, org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureMirror structureMirror, int sizeX, int sizeZ) {
        int newOffsetX = 0;
        int newOffsetZ = 0;
        block0 : switch (structureRotation) {
            case ROTATE_90: {
                switch (structureMirror) {
                    case NONE: {
                        newOffsetX -= sizeZ - 1;
                        break;
                    }
                    case X: {
                        newOffsetZ -= sizeX - 1;
                        newOffsetX -= sizeZ - 1;
                    }
                }
                break;
            }
            case ROTATE_180: {
                switch (structureMirror) {
                    case NONE: {
                        newOffsetX -= sizeX - 1;
                        newOffsetZ -= sizeZ - 1;
                        break;
                    }
                    case Z: {
                        newOffsetX -= sizeX - 1;
                        break;
                    }
                    case X: {
                        newOffsetZ -= sizeZ - 1;
                    }
                }
                break;
            }
            case ROTATE_270: {
                switch (structureMirror) {
                    case NONE: {
                        newOffsetZ -= sizeX - 1;
                        break;
                    }
                    case Z: {
                        newOffsetZ -= sizeX - 1;
                        newOffsetX -= sizeZ - 1;
                    }
                }
                break;
            }
            default: {
                switch (structureMirror) {
                    case Z: {
                        newOffsetZ -= sizeZ - 1;
                        break block0;
                    }
                    case X: {
                        newOffsetX -= sizeX - 1;
                    }
                }
            }
        }
        return Vector3i.from((int)newOffsetX, (int)0, (int)newOffsetZ);
    }

    public static void sendJavaStructurePacket(GeyserSession session, Vector3i blockPosition, Vector3i size, UpdateStructureBlockMode mode, UpdateStructureBlockAction action, StructureSettings settings, boolean boundingBoxVisible, String structureName) {
        StructureMirror mirror = switch (settings.getMirror()) {
            case org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureMirror.X -> StructureMirror.FRONT_BACK;
            case org.geysermc.geyser.shaded.org.cloudburstmc.protocol.bedrock.data.structure.StructureMirror.Z -> StructureMirror.LEFT_RIGHT;
            default -> StructureMirror.NONE;
        };
        org.geysermc.mcprotocollib.protocol.data.game.level.block.StructureRotation rotation = switch (settings.getRotation()) {
            case StructureRotation.ROTATE_90 -> org.geysermc.mcprotocollib.protocol.data.game.level.block.StructureRotation.CLOCKWISE_90;
            case StructureRotation.ROTATE_180 -> org.geysermc.mcprotocollib.protocol.data.game.level.block.StructureRotation.CLOCKWISE_180;
            case StructureRotation.ROTATE_270 -> org.geysermc.mcprotocollib.protocol.data.game.level.block.StructureRotation.COUNTERCLOCKWISE_90;
            default -> org.geysermc.mcprotocollib.protocol.data.game.level.block.StructureRotation.NONE;
        };
        Vector3i offset = settings.getOffset();
        if (session.getStructureBlockCache().getBedrockOffset() != null) {
            offset = settings.getOffset().sub(session.getStructureBlockCache().getBedrockOffset());
        }
        ServerboundSetStructureBlockPacket structureBlockPacket = new ServerboundSetStructureBlockPacket(blockPosition, action, mode, structureName, offset, settings.getSize(), mirror, rotation, "", settings.getIntegrityValue(), settings.getIntegritySeed(), settings.isIgnoringEntities(), false, boundingBoxVisible, false);
        session.sendDownstreamPacket(structureBlockPacket);
    }

    static {
        NbtMapBuilder builder = NbtMap.builder();
        builder.putInt("format_version", 1);
        builder.putCompound("structure", NbtMap.builder().putList("block_indices", NbtType.LIST, (Object[])new NbtList[]{NbtList.EMPTY, NbtList.EMPTY}).putList("entities", NbtType.COMPOUND, (Object[])new NbtMap[0]).putCompound("palette", NbtMap.EMPTY).build());
        builder.putList("structure_world_origin", NbtType.INT, (Object[])new Integer[]{0, 0, 0});
        EMPTY_STRUCTURE_DATA = builder.build();
    }
}

