/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.commons.httpclient.executor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import net.lenni0451.commons.httpclient.HttpClient;
import net.lenni0451.commons.httpclient.HttpResponse;
import net.lenni0451.commons.httpclient.content.HttpContent;
import net.lenni0451.commons.httpclient.executor.RequestExecutor;
import net.lenni0451.commons.httpclient.proxy.ProxyHandler;
import net.lenni0451.commons.httpclient.proxy.SingleProxySelector;
import net.lenni0451.commons.httpclient.requests.HttpContentRequest;
import net.lenni0451.commons.httpclient.requests.HttpRequest;
import net.lenni0451.commons.httpclient.utils.IgnoringTrustManager;

public class URLConnectionExecutor
extends RequestExecutor {
    public URLConnectionExecutor(HttpClient client) {
        super(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public HttpResponse execute(@Nonnull HttpRequest request) throws IOException {
        CookieManager cookieManager = this.getCookieManager(request);
        ProxyHandler proxyHandler = this.client.getProxyHandler();
        SingleProxySelector proxySelector = null;
        if (proxyHandler.isProxySet()) {
            proxySelector = proxyHandler.getProxySelector();
        }
        try {
            if (proxySelector != null) {
                proxySelector.set(false);
            }
            HttpURLConnection connection = this.openConnection(request, cookieManager, proxySelector == null ? null : proxyHandler);
            HttpResponse httpResponse = this.executeRequest(connection, cookieManager, request);
            return httpResponse;
        }
        finally {
            if (proxySelector != null) {
                proxySelector.reset(false);
            }
        }
    }

    private HttpURLConnection openConnection(HttpRequest request, CookieManager cookieManager, ProxyHandler proxyHandler) throws IOException {
        URL url = request.getURL();
        HttpURLConnection connection = proxyHandler == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxyHandler.toJavaProxy());
        if (this.isIgnoreInvalidSSL(request) && connection instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            httpsConnection.setSSLSocketFactory(IgnoringTrustManager.makeIgnoringSSLContext().getSocketFactory());
        }
        this.setupConnection(connection, cookieManager, request);
        connection.connect();
        return connection;
    }

    private void setupConnection(HttpURLConnection connection, @Nullable CookieManager cookieManager, HttpRequest request) throws IOException {
        this.setHeaders(this.getHeaders(request, cookieManager), connection::setRequestProperty, connection::addRequestProperty);
        HttpContentRequest contentRequest = request instanceof HttpContentRequest ? (HttpContentRequest)request : null;
        HttpContent content = contentRequest != null ? contentRequest.getContent() : null;
        connection.setConnectTimeout(this.client.getConnectTimeout());
        connection.setReadTimeout(this.client.getReadTimeout());
        connection.setRequestMethod(request.getMethod());
        connection.setDoInput(true);
        if (contentRequest != null && content != null) {
            connection.setDoOutput(true);
            if (request.isStreamedRequest()) {
                if (content.getLength() >= 0) {
                    connection.setFixedLengthStreamingMode(content.getLength());
                } else {
                    connection.setChunkedStreamingMode(0);
                }
            }
        } else {
            connection.setDoOutput(false);
        }
        switch (request.getFollowRedirects()) {
            case NOT_SET: {
                connection.setInstanceFollowRedirects(this.client.isFollowRedirects());
                break;
            }
            case FOLLOW: {
                connection.setInstanceFollowRedirects(true);
                break;
            }
            case IGNORE: {
                connection.setInstanceFollowRedirects(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeRequest(HttpURLConnection connection, @Nullable CookieManager cookieManager, HttpRequest request) throws IOException {
        boolean closeConnection = true;
        try {
            HttpResponse response;
            if (connection.getDoOutput()) {
                HttpContent content = ((HttpContentRequest)request).getContent();
                try (OutputStream os = connection.getOutputStream();){
                    content.transferTo(os);
                }
            }
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>(connection.getHeaderFields());
            headers.remove(null);
            InputStream body = this.getInputStream(connection);
            if (request.isStreamedResponse()) {
                response = new HttpResponse(request.getURL(), connection.getResponseCode(), body, headers);
                closeConnection = false;
            } else {
                byte[] bodyContent = this.readAllBytes(body, connection.getContentLength());
                response = new HttpResponse(request.getURL(), connection.getResponseCode(), bodyContent, headers);
            }
            this.updateCookies(cookieManager, request.getURL(), connection.getHeaderFields());
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            if (closeConnection) {
                connection.disconnect();
            }
        }
    }

    private InputStream getInputStream(HttpURLConnection connection) throws IOException {
        InputStream is = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
        if (is == null) {
            is = new ByteArrayInputStream(new byte[0]);
        }
        return is;
    }

    private byte[] readAllBytes(InputStream is, int contentLength) throws IOException {
        int len;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(contentLength >= 0 ? contentLength : 1024);
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) >= 0) {
            baos.write(buffer, 0, len);
        }
        return baos.toByteArray();
    }
}

