/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.geyser.platform.neoforge;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.IModInfo;
import org.geysermc.geyser.dump.BootstrapDumpInfo;
import org.geysermc.geyser.text.AsteriskSerializer;

public class GeyserNeoForgeDumpInfo
extends BootstrapDumpInfo {
    private final String platformName;
    private final String platformVersion;
    private final String minecraftVersion;
    private final Dist dist;
    @AsteriskSerializer.Asterisk(isIp=true)
    private final String serverIP;
    private final int serverPort;
    private final boolean onlineMode;
    private final List<ModInfo> mods;

    public GeyserNeoForgeDumpInfo(MinecraftServer server) {
        this.platformName = server.getServerModName();
        this.platformVersion = FMLLoader.getCurrent().getVersionInfo().neoForgeVersion();
        this.minecraftVersion = FMLLoader.getCurrent().getVersionInfo().mcVersion();
        this.dist = FMLLoader.getCurrent().getDist();
        this.serverIP = server.getLocalIp() == null ? "unknown" : server.getLocalIp();
        this.serverPort = server.getPort();
        this.onlineMode = server.usesAuthentication();
        this.mods = new ArrayList<ModInfo>();
        for (IModInfo mod : ModList.get().getMods()) {
            this.mods.add(new ModInfo(ModList.get().isLoaded(mod.getModId()), mod.getModId(), mod.getVersion().toString(), mod.getModURL().map(URL::toString).orElse("")));
        }
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public String getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public Dist getDist() {
        return this.dist;
    }

    public String getServerIP() {
        return this.serverIP;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    public List<ModInfo> getMods() {
        return this.mods;
    }

    public static class ModInfo {
        public boolean enabled;
        public String name;
        public String version;
        public String url;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }

        public ModInfo(boolean enabled, String name, String version, String url) {
            this.enabled = enabled;
            this.name = name;
            this.version = version;
            this.url = url;
        }
    }
}

